## ----config, include=FALSE----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, cache = TRUE)

## ----rnb1---------------------------------------------------------------------
x <- carts::rnb(1e4, mean = 1, variance = 2)
c(mean(x), var(x))

## ----gammaplot----------------------------------------------------------------
b <- 2
a1 <- 1
a2 <- 3
r <- 0.3
n <- 1e4
## Shape-rate parametrization
z1 <- rgamma(n, a1, b)
z2 <- rgamma(n, a2, b)
## r(z1+z2) ~  gamma(a1+a2, b/r)
plot(density(r * (z1 + z2)))
curve(dgamma(x, a1 + a2, b / r), add = TRUE, col = "red", lty = 2)

## ----rnb.gamma----------------------------------------------------------------
z <- carts::rnb(1e5,
  mean = 2,
  gamma.variance = 3
)
c(mean(z), var(z))

## ----rnbplot------------------------------------------------------------------
x <- seq(0, 30)
mf <- function(y, x) sapply(x, function(x) mean(y == x))
plot(x, mf(z, x), type = "h", ylab = "p(x)")
y <- rpois(length(z), 2 * rgamma(length(z), 1 / 3, 1 / 3))
lines(x + 0.1, mf(y, x), type = "h", col = "red")

