## ----include = FALSE----------------------------------------------------------
  knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
  )

## ----setup--------------------------------------------------------------------
  # install.packages("contrastable")
library(contrastable)
library(dplyr)

## ----eval = FALSE-------------------------------------------------------------
# enlist_contrasts(my_dataframe,
#                  varname ~ contrast_scheme + reference * intercept - dropped | labels)

## -----------------------------------------------------------------------------
model_data <-
  mtcars |>
  dplyr::mutate(gear_type = ifelse(gear %% 2 == 0, "even", "odd")) |>
  set_contrasts(gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                print_contrasts = TRUE)

summary(lm(mpg ~ gear_type, data = model_data))

## -----------------------------------------------------------------------------
model_data <-
  mtcars |>
  dplyr::mutate(gear_type = ifelse(gear %% 2 == 0, "even", "odd")) |>
  set_contrasts(gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                print_contrasts = TRUE,
                carb + cyl ~ helmert_code)

summary(lm(mpg ~ gear_type + carb + cyl, data = model_data))

## -----------------------------------------------------------------------------
model_data <-
  mtcars |>
  dplyr::mutate(gear_type = ifelse(gear %% 2 == 0, "even", "odd")) |>
  set_contrasts(gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                vs:carb ~ helmert_code,
                print_contrasts = TRUE)

## -----------------------------------------------------------------------------
model_contrasts <-
  mtcars |>
  dplyr::mutate(gear_type = ifelse(gear %% 2 == 0, "even", "odd")) |>
  enlist_contrasts(gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"))

model_contrasts

## -----------------------------------------------------------------------------
model_contrasts <-
  mtcars |>
  dplyr::mutate(gear_type = ifelse(gear %% 2 == 0, "even", "odd")) |>
  enlist_contrasts(gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                   carb + cyl ~ sum_code)

model_contrasts

## -----------------------------------------------------------------------------
carb_contrasts <- scaled_sum_code(6)

enlist_contrasts(mtcars,
                 cyl ~ sum_code,
                 carb ~ carb_contrasts)

## -----------------------------------------------------------------------------
contr.sum(3) # third row = reference level

enlist_contrasts(mtcars, cyl ~ contr.sum) # == sum_code

## -----------------------------------------------------------------------------
enlist_contrasts(mtcars, cyl ~ I(contr.sum)) # == sum_code

## -----------------------------------------------------------------------------
mtcars2 <- 
  dplyr::mutate(mtcars, gear_type = ifelse(gear %% 2 == 0, "even", "odd"))

glimpse_contrasts(mtcars2,
                  gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                  carb + cyl ~ sum_code)

## -----------------------------------------------------------------------------
mtcars2 <- set_contrasts(mtcars2, 
                         gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                         carb + cyl ~ sum_code) 

glimpse_contrasts(mtcars2,
                  gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                  carb + cyl ~ sum_code)

## -----------------------------------------------------------------------------
my_contrasts <- list(gear_type ~ scaled_sum_code + "odd" | c("Odd-Even"),
                     carb + cyl ~ sum_code)

mtcars2 <- 
  mtcars |> 
  dplyr::mutate(gear_type = ifelse(gear %% 2 == 0, "even", "odd")) |> 
  set_contrasts(my_contrasts)

glimpse_contrasts(mtcars2, my_contrasts)

## -----------------------------------------------------------------------------
mtcars2 |> 
  decompose_contrasts(~gear_type + cyl) |> 
  head()

## -----------------------------------------------------------------------------
enlist_contrasts(mtcars, carb ~ contr.helmert)

## ----eval = FALSE-------------------------------------------------------------
# enlist_contrasts(mtcars, carb ~ helmert_code())

## ----echo = FALSE-------------------------------------------------------------
carb_contrasts <- enlist_contrasts(mtcars, carb ~ helmert_code())
carb_contrasts[["carb"]] <- MASS::fractions(carb_contrasts[[1]])
carb_contrasts

