/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api.grid;

import ec.util.spreadsheet.helpers.ArraySheet;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import jdplus.toolkit.base.tsp.grid.GridDataType;
import jdplus.toolkit.base.tsp.grid.GridOutput;
import lombok.Generated;
import lombok.NonNull;

public final class SheetGridOutput
implements GridOutput {
    private final Predicate<Class<?>> isSupportedDataType;
    private final ZoneId zoneId = ZoneId.systemDefault();
    private ArraySheet result = null;

    @NonNull
    public Set<GridDataType> getDataTypes() {
        EnumSet<GridDataType> dataTypes = EnumSet.noneOf(GridDataType.class);
        if (this.isSupportedDataType.test(String.class)) {
            dataTypes.add(GridDataType.STRING);
        }
        if (this.isSupportedDataType.test(Double.class)) {
            dataTypes.add(GridDataType.DOUBLE);
        }
        if (this.isSupportedDataType.test(Date.class)) {
            dataTypes.add(GridDataType.LOCAL_DATE_TIME);
        }
        return dataTypes;
    }

    @NonNull
    public GridOutput.Stream open(@NonNull String name, int rows, int columns) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new SheetGridOutputStream(ArraySheet.builder((int)rows, (int)columns).name(name));
    }

    public ArraySheet getResult() {
        return this.result;
    }

    @Generated
    private SheetGridOutput(Predicate<Class<?>> isSupportedDataType) {
        this.isSupportedDataType = isSupportedDataType;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull SheetGridOutput of(Predicate<Class<?>> isSupportedDataType) {
        return new SheetGridOutput(isSupportedDataType);
    }

    private final class SheetGridOutputStream
    implements GridOutput.Stream {
        @NonNull
        private final ArraySheet.Builder sheet;
        private int row = 0;
        private int column = 0;

        public void writeCell(Object value) {
            this.moveTo(this.row, this.column);
            this.sheet.value(this.row, this.column, this.toSheetValue(value));
            ++this.column;
        }

        public void writeEndOfRow() {
            ++this.row;
            this.column = 0;
        }

        public void close() {
            SheetGridOutput.this.result = this.sheet.build();
        }

        private void moveTo(int row, int column) {
            this.row = row;
            this.column = column;
        }

        private Object toSheetValue(Object value) {
            return value instanceof LocalDateTime ? this.fromDateTime((LocalDateTime)value) : value;
        }

        private Date fromDateTime(LocalDateTime o) {
            return Date.from(o.atZone(SheetGridOutput.this.zoneId).toInstant());
        }

        @Generated
        public SheetGridOutputStream(ArraySheet.Builder sheet) {
            if (sheet == null) {
                throw new NullPointerException("sheet is marked non-null but is null");
            }
            this.sheet = sheet;
        }
    }
}

