/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.jspecify.annotations.Nullable;

public final class ObsFormat {
    static final Locale NULL_AS_SYSTEM_DEFAULT = null;
    public static final ObsFormat DEFAULT = new ObsFormat(Locale.ROOT, "", "", false);
    private final @Nullable Locale locale;
    @NonNull
    private final String dateTimePattern;
    @NonNull
    private final String numberPattern;
    private final boolean ignoreNumberGrouping;
    private static final String SEP = " ~ ";
    private static final TemporalQuery[] TEMPORAL_QUERIES = new TemporalQuery[]{LocalDateTime::from, o -> LocalDate.from(o).atStartOfDay()};

    @NonNull
    public static ObsFormat getSystemDefault() {
        return new ObsFormat(NULL_AS_SYSTEM_DEFAULT, "", "", false);
    }

    public static Builder builder() {
        return DEFAULT.toBuilder();
    }

    @NonNull
    public Formatter<LocalDateTime> dateTimeFormatter() {
        try {
            return Formatter.onDateTimeFormatter((DateTimeFormatter)this.newDateTimeFormatter());
        }
        catch (IllegalArgumentException ex) {
            return Formatter.onNull();
        }
    }

    @NonNull
    public Parser<LocalDateTime> dateTimeParser() {
        try {
            return Parser.onDateTimeFormatter((DateTimeFormatter)this.newDateTimeFormatter(), (TemporalQuery[])TEMPORAL_QUERIES);
        }
        catch (IllegalArgumentException ex) {
            return Parser.onNull();
        }
    }

    @NonNull
    public Formatter<Date> calendarFormatter() {
        try {
            return Formatter.onDateFormat((DateFormat)this.newDateFormat());
        }
        catch (IllegalArgumentException ex) {
            return Formatter.onNull();
        }
    }

    @NonNull
    public Parser<Date> calendarParser() {
        try {
            return Parser.onDateFormat((DateFormat)this.newDateFormat());
        }
        catch (IllegalArgumentException ex) {
            return Parser.onNull();
        }
    }

    @NonNull
    public Formatter<Number> numberFormatter() {
        try {
            return Formatter.onNumberFormat((NumberFormat)this.newNumberFormat());
        }
        catch (IllegalArgumentException ex) {
            return Formatter.onNull();
        }
    }

    @NonNull
    public Parser<Number> numberParser() {
        try {
            return Parser.onNumberFormat((NumberFormat)this.newNumberFormat());
        }
        catch (IllegalArgumentException ex) {
            return Parser.onNull();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.locale != NULL_AS_SYSTEM_DEFAULT) {
            builder.append(this.locale);
        }
        builder.append(SEP);
        if (!this.dateTimePattern.isEmpty()) {
            builder.append(this.dateTimePattern);
        }
        builder.append(SEP);
        if (!this.numberPattern.isEmpty()) {
            builder.append(this.numberPattern);
        }
        if (this.ignoreNumberGrouping) {
            builder.append(SEP);
            builder.append("ignore-grouping");
        }
        return builder.toString();
    }

    DateTimeFormatter newDateTimeFormatter() throws IllegalArgumentException {
        Locale nonNullLocale = this.getLocaleOrSystemDefault();
        DateTimeFormatterBuilder result = new DateTimeFormatterBuilder();
        if (!this.dateTimePattern.isEmpty()) {
            result.appendPattern(this.dateTimePattern);
        } else if (Locale.ROOT.equals(nonNullLocale)) {
            result.appendPattern("yyyy-MM-dd['T'HH:mm:ss]");
        } else {
            result.append(new DateTimeFormatterBuilder().appendLocalized(FormatStyle.MEDIUM, null).toFormatter(nonNullLocale)).optionalStart().appendLiteral(' ').append(new DateTimeFormatterBuilder().appendLocalized(null, FormatStyle.MEDIUM).toFormatter(nonNullLocale)).optionalEnd();
        }
        result.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
        return result.toFormatter(nonNullLocale);
    }

    DateFormat newDateFormat() throws IllegalArgumentException {
        Locale nonNullLocale = this.getLocaleOrSystemDefault();
        DateFormat result = !this.dateTimePattern.isEmpty() ? new SimpleDateFormat(this.dateTimePattern, nonNullLocale) : (Locale.ROOT.equals(nonNullLocale) ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", nonNullLocale) : SimpleDateFormat.getDateInstance(2, nonNullLocale));
        result.setLenient(this.dateTimePattern.isEmpty() && this.locale == NULL_AS_SYSTEM_DEFAULT);
        return result;
    }

    NumberFormat newNumberFormat() throws IllegalArgumentException {
        NumberFormat result;
        Locale nonNullLocale = this.getLocaleOrSystemDefault();
        NumberFormat numberFormat = !this.numberPattern.isEmpty() ? new DecimalFormat(this.numberPattern, DecimalFormatSymbols.getInstance(nonNullLocale)) : (result = Locale.ROOT.equals(nonNullLocale) ? new DecimalFormat("#.################", DecimalFormatSymbols.getInstance(nonNullLocale)) : NumberFormat.getInstance(nonNullLocale));
        if (this.ignoreNumberGrouping) {
            result.setGroupingUsed(false);
        }
        return result;
    }

    private Locale getLocaleOrSystemDefault() {
        return this.locale != NULL_AS_SYSTEM_DEFAULT ? this.locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    @Generated
    ObsFormat(@Nullable Locale locale, @NonNull String dateTimePattern, @NonNull String numberPattern, boolean ignoreNumberGrouping) {
        if (dateTimePattern == null) {
            throw new NullPointerException("dateTimePattern is marked non-null but is null");
        }
        if (numberPattern == null) {
            throw new NullPointerException("numberPattern is marked non-null but is null");
        }
        this.locale = locale;
        this.dateTimePattern = dateTimePattern;
        this.numberPattern = numberPattern;
        this.ignoreNumberGrouping = ignoreNumberGrouping;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().locale(this.locale).dateTimePattern(this.dateTimePattern).numberPattern(this.numberPattern).ignoreNumberGrouping(this.ignoreNumberGrouping);
    }

    @Generated
    public @Nullable Locale getLocale() {
        return this.locale;
    }

    @NonNull
    @Generated
    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    @NonNull
    @Generated
    public String getNumberPattern() {
        return this.numberPattern;
    }

    @Generated
    public boolean isIgnoreNumberGrouping() {
        return this.ignoreNumberGrouping;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObsFormat)) {
            return false;
        }
        ObsFormat other = (ObsFormat)o;
        if (this.isIgnoreNumberGrouping() != other.isIgnoreNumberGrouping()) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        String this$dateTimePattern = this.getDateTimePattern();
        String other$dateTimePattern = other.getDateTimePattern();
        if (this$dateTimePattern == null ? other$dateTimePattern != null : !this$dateTimePattern.equals(other$dateTimePattern)) {
            return false;
        }
        String this$numberPattern = this.getNumberPattern();
        String other$numberPattern = other.getNumberPattern();
        return !(this$numberPattern == null ? other$numberPattern != null : !this$numberPattern.equals(other$numberPattern));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreNumberGrouping() ? 79 : 97);
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        String $dateTimePattern = this.getDateTimePattern();
        result = result * 59 + ($dateTimePattern == null ? 43 : $dateTimePattern.hashCode());
        String $numberPattern = this.getNumberPattern();
        result = result * 59 + ($numberPattern == null ? 43 : $numberPattern.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Locale locale;
        @Generated
        private String dateTimePattern;
        @Generated
        private String numberPattern;
        @Generated
        private boolean ignoreNumberGrouping;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder locale(@Nullable Locale locale) {
            this.locale = locale;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder dateTimePattern(@NonNull String dateTimePattern) {
            if (dateTimePattern == null) {
                throw new NullPointerException("dateTimePattern is marked non-null but is null");
            }
            this.dateTimePattern = dateTimePattern;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder numberPattern(@NonNull String numberPattern) {
            if (numberPattern == null) {
                throw new NullPointerException("numberPattern is marked non-null but is null");
            }
            this.numberPattern = numberPattern;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ignoreNumberGrouping(boolean ignoreNumberGrouping) {
            this.ignoreNumberGrouping = ignoreNumberGrouping;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull ObsFormat build() {
            return new ObsFormat(this.locale, this.dateTimePattern, this.numberPattern, this.ignoreNumberGrouping);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "ObsFormat.Builder(locale=" + String.valueOf(this.locale) + ", dateTimePattern=" + this.dateTimePattern + ", numberPattern=" + this.numberPattern + ", ignoreNumberGrouping=" + this.ignoreNumberGrouping + ")";
        }
    }
}

