/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import standalone_spreadsheet.com.github.miachm.sods.FileEntry;
import standalone_spreadsheet.com.github.miachm.sods.OdsOptionParameters;
import standalone_spreadsheet.com.github.miachm.sods.OdsReader;
import standalone_spreadsheet.com.github.miachm.sods.OdsWritter;
import standalone_spreadsheet.com.github.miachm.sods.Sheet;

public class SpreadSheet
implements Cloneable {
    private final List<Sheet> sheets = new ArrayList<Sheet>();
    private final Map<String, FileEntry> extraFiles = new HashMap<String, FileEntry>();
    private static final Set<String> reservedFiles = Stream.of("content.xml", "styles.xml", "META-INF/manifest.xml", "mimetype").collect(Collectors.toCollection(HashSet::new));

    public SpreadSheet() {
    }

    public SpreadSheet(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public SpreadSheet(InputStream in) throws IOException {
        OdsReader.load(in, this);
    }

    public SpreadSheet(InputStream in, OdsOptionParameters options) throws IOException {
        if (options == null) {
            throw new NullPointerException("OdsOptionParameters cannot be null");
        }
        OdsReader.load(in, this, options);
    }

    public void appendSheet(Sheet sheet) {
        this.addSheet(sheet, this.sheets.size());
    }

    public void addSheet(Sheet sheet, int pos) {
        if (sheet == null) {
            throw new NullPointerException();
        }
        this.sheets.add(pos, sheet);
    }

    public void clear() {
        this.sheets.clear();
    }

    public void deleteSheet(int pos) {
        this.sheets.remove(pos);
    }

    public boolean deleteSheet(String name) {
        return this.sheets.removeIf(sheet -> sheet.getName().equals(name));
    }

    public boolean deleteSheet(Sheet sheet) {
        return this.sheets.remove(sheet);
    }

    public List<Sheet> getSheets() {
        return Collections.unmodifiableList(this.sheets);
    }

    public int getNumSheets() {
        return this.sheets.size();
    }

    public Sheet getSheet(String name) {
        for (Sheet sheet : this.sheets) {
            if (!sheet.getName().equals(name)) continue;
            return sheet;
        }
        return null;
    }

    public Sheet getSheet(int index) {
        return this.sheets.get(index);
    }

    public void setSheet(Sheet sheet, int pos) {
        if (sheet == null) {
            throw new NullPointerException();
        }
        this.sheets.set(pos, sheet);
    }

    public void save(File out) throws IOException {
        this.save(new FileOutputStream(out));
    }

    public void save(OutputStream out) throws IOException {
        OdsWritter.save(out, this);
    }

    Collection<FileEntry> getExtraFiles() {
        return this.extraFiles.values();
    }

    public boolean setAdditionalFile(String path, String mimetype, byte[] data) {
        if (reservedFiles.contains(path)) {
            throw new IllegalArgumentException("The file " + path + " is a reserved name");
        }
        return this.extraFiles.put(path, new FileEntry(path, mimetype, data)) != null;
    }

    public void removeAdditionalFile(String path) {
        this.extraFiles.remove(path);
    }

    @Deprecated
    public void sortSheets() {
        Collections.sort(this.sheets);
    }

    @Deprecated
    public void sortSheets(Comparator<Sheet> comparator) {
        this.sheets.sort(comparator);
    }

    public void trimSheets() {
        for (Sheet sheet : this.sheets) {
            sheet.trim();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadSheet that = (SpreadSheet)o;
        return this.sheets.equals(that.sheets);
    }

    public int hashCode() {
        return this.sheets.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "SpreadSheet{sheets=" + this.sheets + '}';
    }
}

