/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.helpers.FileHelper;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import spreadsheet.xlsx.XlsxReader;

public final class XlsxBookFactory
extends Book.Factory {
    private static final String XLSX_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final String XLSM_TYPE = "application/vnd.ms-excel.sheet.macroEnabled.12";
    private static final byte[] ZIP_HEADER = new byte[]{80, 75};

    @NonNull
    public String getName() {
        return "Xlsx";
    }

    public int getRank() {
        return 127;
    }

    @NonNull
    public Map<String, List<String>> getExtensionsByMediaType() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put(XLSM_TYPE, Collections.singletonList(".xlsm"));
        result.put(XLSX_TYPE, Collections.singletonList(".xlsx"));
        return result;
    }

    public boolean accept(File file) {
        return FileHelper.accept((File)file, (DirectoryStream.Filter)((Object)this));
    }

    public boolean accept(Path file) throws IOException {
        return FileHelper.hasExtension((Path)file, (String[])new String[]{".xlsx", ".xlsm"}) && (!Files.exists(file, new LinkOption[0]) || FileHelper.hasMagicNumber((Path)file, (byte[])ZIP_HEADER));
    }

    @NonNull
    public Book load(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        XlsxBookFactory.checkFile(file);
        return new XlsxReader().read(file.toPath());
    }

    @NonNull
    public Book load(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (stream.available() == 0) {
            throw new EOFException();
        }
        return new XlsxReader().read(stream);
    }

    public boolean canStore() {
        return false;
    }

    public void store(@NonNull OutputStream stream, @NonNull Book book) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (book == null) {
            throw new NullPointerException("book is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Not supported");
    }

    @NonNull
    private static File checkFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists()) {
            throw new NoSuchFileException(file.getPath());
        }
        if (!file.canRead() || file.isDirectory()) {
            throw new AccessDeniedException(file.getPath());
        }
        if (file.length() == 0L) {
            throw new EOFException(file.getPath());
        }
        return file;
    }
}

