/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeParseException;
import jdplus.toolkit.base.api.time.ISO_8601;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeIntervalAccessor;
import jdplus.toolkit.base.api.time.TimeIntervalFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.util.HasShortStringRepresentation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class CalendarPeriod
implements TimeSeriesInterval<Period>,
Comparable<CalendarPeriod>,
HasShortStringRepresentation {
    @NonNull
    private final LocalDate start;
    @NonNull
    private final LocalDate end;
    private static final TimeIntervalFormatter.StartEnd ISO_8601 = TimeIntervalFormatter.StartEnd.of(TemporalFormatter.EXTENDED_CALENDAR, LocalDate::from, false);
    private static final TimeIntervalFormatter.StartEnd ISO_8601_CONCISE = ISO_8601.withConcise(true);

    @Override
    @NonNull
    public LocalDateTime start() {
        return this.start.atStartOfDay();
    }

    @Override
    @NonNull
    public LocalDateTime end() {
        return this.end.atStartOfDay();
    }

    @Override
    public boolean contains(LocalDateTime element) {
        return element.isBefore(this.end.atStartOfDay()) && !element.isBefore(this.start.atStartOfDay());
    }

    @Override
    @NonNull
    public Period getDuration() {
        return Period.between(this.start, this.end);
    }

    @Override
    public int compareTo(CalendarPeriod t) {
        if (this.start.equals(t.start) && this.end.isAfter(t.end)) {
            return 0;
        }
        if (!this.end.isAfter(t.start)) {
            return -1;
        }
        if (!t.end.isAfter(this.start)) {
            return 1;
        }
        throw new TsException("Incompatible periods");
    }

    public String toString() {
        return ISO_8601.format(this);
    }

    @Override
    @NonNull
    public String toShortString() {
        return ISO_8601_CONCISE.format(this);
    }

    @NonNull
    public static CalendarPeriod parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ISO_8601.parse(text, CalendarPeriod::from);
    }

    @NonNull
    public static CalendarPeriod from(@NonNull TimeIntervalAccessor timeInterval) {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        return CalendarPeriod.of(LocalDate.from(timeInterval.start()), LocalDate.from(timeInterval.end()));
    }

    @Generated
    private CalendarPeriod(@NonNull LocalDate start, @NonNull LocalDate end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.start = start;
        this.end = end;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull CalendarPeriod of(@NonNull LocalDate start, @NonNull LocalDate end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return new CalendarPeriod(start, end);
    }

    @NonNull
    @Generated
    public LocalDate getStart() {
        return this.start;
    }

    @NonNull
    @Generated
    public LocalDate getEnd() {
        return this.end;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarPeriod)) {
            return false;
        }
        CalendarPeriod other = (CalendarPeriod)o;
        LocalDate this$start = this.getStart();
        LocalDate other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDate this$end = this.getEnd();
        LocalDate other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDate $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }
}

