/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.Formatter;
import java.util.Locale;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.IFilter;

public interface IFiniteFilter
extends IFilter {
    default public int length() {
        return this.getUpperBound() - this.getLowerBound() + 1;
    }

    @Override
    default public boolean hasLowerBound() {
        return true;
    }

    @Override
    default public boolean hasUpperBound() {
        return true;
    }

    public int getLowerBound();

    public int getUpperBound();

    public IntToDoubleFunction weights();

    default public double[] weightsToArray() {
        double[] w = new double[this.length()];
        IntToDoubleFunction weights = this.weights();
        int i = 0;
        int j = this.getLowerBound();
        while (i < w.length) {
            w[i] = weights.applyAsDouble(j);
            ++i;
            ++j;
        }
        return w;
    }

    @Override
    default public Complex frequencyResponse(double freq) {
        return FilterUtility.frequencyResponse(this.weights(), this.getLowerBound(), this.getUpperBound(), freq);
    }

    public IFiniteFilter mirror();

    default public double apply(DoubleSeq in) {
        IntToDoubleFunction weights = this.weights();
        int lb = this.getLowerBound();
        int ub = this.getUpperBound();
        double s = 0.0;
        DoubleSeqCursor cursor = in.cursor();
        for (int j = lb; j <= ub; ++j) {
            s += weights.applyAsDouble(j) * cursor.getAndNext();
        }
        return s;
    }

    default public double apply(double[] in, int pos, int inc) {
        IntToDoubleFunction weights = this.weights();
        int lb = this.getLowerBound();
        int ub = this.getUpperBound();
        double s = 0.0;
        if (inc == 1) {
            int k = lb;
            int t = pos + lb;
            while (k <= ub) {
                s += in[t] * weights.applyAsDouble(k);
                ++k;
                ++t;
            }
        } else {
            int k = lb;
            int t = pos + lb * inc;
            while (k <= ub) {
                s += in[t] * weights.applyAsDouble(k);
                ++k;
                t += inc;
            }
        }
        return s;
    }

    default public void apply(DoubleSeq in, DoubleSeq.Mutable out) {
        double[] w = this.weightsToArray();
        int nz = 0;
        int nw = w.length;
        int nw2 = nw >> 1;
        boolean sparse = true;
        for (int i = 0; i < nw; ++i) {
            if (w[i] == 0.0 || ++nz <= nw2) continue;
            sparse = false;
            break;
        }
        if (sparse) {
            int len = in.length() - w.length + 1;
            out.setAY(w[0], in.range(0, len));
            for (int j = 1; j < nw; ++j) {
                if (w[j] == 0.0) continue;
                out.addAY(w[j], in.range(j, len + j));
            }
        } else {
            int n = out.length();
            DoubleSeqCursor.OnMutable cursor = out.cursor();
            DoubleSeqCursor icur = in.cursor();
            for (int i = 0; i < n; ++i) {
                icur.moveTo(i);
                double s = 0.0;
                for (int k = 0; k < nw; ++k) {
                    s += icur.getAndNext() * w[k];
                }
                cursor.setAndNext(s);
            }
        }
    }

    default public void apply(DataBlock in, DataBlock out) {
        double[] w = this.weightsToArray();
        double[] xin = in.getStorage();
        int start = in.getStartPosition();
        int inc = in.getIncrement();
        int n = out.length();
        double[] xout = out.getStorage();
        int ostart = out.getStartPosition();
        int oinc = out.getIncrement();
        if (inc == 1) {
            int i = 0;
            int j = start;
            int o = ostart;
            while (i < n) {
                double s = 0.0;
                int k = 0;
                int t = j;
                while (k < w.length) {
                    s += xin[t] * w[k];
                    ++k;
                    ++t;
                }
                xout[o] = s;
                ++i;
                ++j;
                o += oinc;
            }
        } else {
            int i = 0;
            int j = start;
            int o = ostart;
            while (i < n) {
                double s = 0.0;
                int k = 0;
                int t = j;
                while (k < w.length) {
                    s += xin[t] * w[k];
                    ++k;
                    t += inc;
                }
                xout[o] = s;
                ++i;
                j += inc;
                o += oinc;
            }
        }
    }

    default public void apply2(DataBlock in, DataBlock out) {
        IntToDoubleFunction weights = this.weights();
        int l = this.getLowerBound();
        int u = this.getUpperBound();
        int n = out.length();
        int i = l;
        int j = 0;
        while (i <= u) {
            double w = weights.applyAsDouble(i);
            if (w != 0.0) {
                out.addAY(w, in.range(j, j + n));
            }
            ++i;
            ++j;
        }
    }

    public static String toString(IFiniteFilter filter) {
        StringBuilder sb = new StringBuilder();
        String fmt = "%6g";
        boolean sign = false;
        IntToDoubleFunction weights = filter.weights();
        for (int i = filter.getLowerBound(); i <= filter.getUpperBound(); ++i) {
            double v = weights.applyAsDouble(i);
            double av = Math.abs(v);
            if (!(av >= 1.0E-6)) continue;
            if (av > v) {
                sb.append(" - ");
            } else if (sign) {
                sb.append(" + ");
            }
            if (av != 1.0 || i == 0) {
                sb.append(new Formatter(Locale.ROOT).format(fmt, av).toString());
            }
            sign = true;
            if (i < 0) {
                sb.append("(t-").append(-i).append(')');
                continue;
            }
            if (i > 0) {
                sb.append("(t+").append(i).append(')');
                continue;
            }
            sb.append("(t)");
        }
        return sb.toString();
    }

    public static boolean equals(IFiniteFilter f1, IFiniteFilter f2, double eps) {
        int l = f1.getLowerBound();
        int u = f1.getUpperBound();
        if (l != f2.getLowerBound() || u != f2.getUpperBound()) {
            return false;
        }
        IntToDoubleFunction w = f1.weights();
        IntToDoubleFunction fw = f2.weights();
        for (int i = l; i <= u; ++i) {
            if (!(Math.abs(w.applyAsDouble(i) - fw.applyAsDouble(i)) > eps)) continue;
            return false;
        }
        return true;
    }
}

