## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(gageRR)

## ----data---------------------------------------------------------------------
head(data)

## ----xbar---------------------------------------------------------------------
xbar_repeat(data, part = 'SN', operator = 'Operator', meas = 'Measure')

xbar_reproduce(data, part = 'SN', operator = 'Operator', meas = 'Measure')

part_to_part(data, part = 'SN', meas = 'Measure' )

## ----xbar_varcomps------------------------------------------------------------
xbar_varcomps(data, part = 'SN', operator = 'Operator', meas = 'Measure')

## ----ss-----------------------------------------------------------------------
ss_calcs(data, part = 'SN', operator = 'Operator', meas = 'Measure')

## ----anova_varcomps-----------------------------------------------------------
anova_var_calcs(data, part = 'SN', operator = 'Operator', meas = 'Measure')

## ----gage_eval----------------------------------------------------------------
grr_calc(data, part = 'SN', operator = 'Operator', meas = 'Measure', LSL = NULL, USL = .04, method = 'anova')

