pureMiMatrix<-function(X,zeroDiag=TRUE){
sapply(1:ncol(X),function(e) miScores(X,X[,e]))->ans
if(zeroDiag) diag(ans)<-0
colnames(ans)<-names(X)
ans
}

pureNmiMatrix<-function(X,zeroDiag=TRUE){
sapply(1:ncol(X),function(e) njmiScores(X,X[,e],rep(1,nrow(X))))->ans
if(zeroDiag) diag(ans)<-0
colnames(ans)<-names(X)
ans
}

pureDnmiMatrix<-function(X,zeroDiag=TRUE){
sapply(1:ncol(X),function(e) miScores(X,X[,e]))->ans
if(zeroDiag) diag(ans)<-0
colnames(ans)<-names(X)
t(t(ans)/hScores(X))
}

pureCmiMatrix<-function(X,Z,zeroDiag=TRUE){
sapply(1:ncol(X),function(e) cmiScores(X,X[,e],Z))->ans
if(zeroDiag) diag(ans)<-0
colnames(ans)<-names(X)
ans
}

pureICmiMatrix<-function(X,Y){
sapply(1:ncol(X),function(e) cmiScores(X,Y,X[,e]))->ans
colnames(ans)<-names(X)
ans
}

pureJmiMatrix<-function(X,Z,zeroDiag=TRUE){
sapply(1:ncol(X),function(e) jmiScores(X,X[,e],Z))->ans
if(zeroDiag) diag(ans)<-0
colnames(ans)<-names(X)
ans
}

pureNjmiMatrix<-function(X,Z,zeroDiag=TRUE){
sapply(1:ncol(X),function(e) njmiScores(X,X[,e],Z))->ans
if(zeroDiag) diag(ans)<-0
colnames(ans)<-names(X)
ans
}

miMatrix(iris,FALSE)->M
expect_equal(diag(M),hScores(iris))
expect_equal(t(M),M)
expect_equal(rownames(M),colnames(M))
expect_equal(rownames(M),names(iris))
expect_equal(
 diag(miMatrix(iris)),
 setNames(rep(0,5),names(iris))
)

expect_equal(
 pureMiMatrix(iris,FALSE),
 miMatrix(iris,FALSE)
)

expect_equal(
 pureNmiMatrix(iris,FALSE),
 nmiMatrix(iris,FALSE)
)

expect_equal(
 pureDnmiMatrix(iris,FALSE),
 dnmiMatrix(iris,FALSE)
)

expect_equal(
 pureCmiMatrix(iris,iris[,5],FALSE),
 cmiMatrix(iris,iris[,5],FALSE)
)

expect_equal(
 pureICmiMatrix(iris,iris[,5]),
 icmiMatrix(iris,iris[,5])
)

expect_equal(
 pureJmiMatrix(iris,iris[,5],FALSE),
 jmiMatrix(iris,iris[,5],FALSE)
)

expect_equal(
 pureNjmiMatrix(iris,iris[,5],FALSE),
 njmiMatrix(iris,iris[,5],FALSE)
)

triScores(cbind(iris,C=rep(1,150)))->z
expect_equal(names(z),c("Var1","Var2","Var3","MI"))
expect_equal(nrow(z),6*5*4/6)

z[z$Var3=="C",]->z
expect_equal(z$MI,rep(0,10))

expect_equal(triScores(iris[,c(1,2,1)])$MI,miScores(iris[,1],iris[,2]))
