/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.Objects;
import standalone_spreadsheet.com.github.miachm.sods.Style;

class ColumnStyle
implements Cloneable {
    static final ColumnStyle default_style = new ColumnStyle();
    private Double width;
    private boolean isHidden;
    private Style defaultCellStyle = Style.default_style;
    private static final double EQUIVALENCE_CM = 10.0;
    private static final double EQUIVALENCE_PX = 0.264583333;
    private static final double EQUIVALENCE_IN = 25.4;
    private static final double EQUIVALENCE_PT = 2.834645669291339;
    private static final double EQUIVALENCE_PC = 0.2362204724409449;

    ColumnStyle() {
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    void setWidth(String width) {
        this.width = ColumnStyle.getValue(width);
    }

    public static Double getValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty() || value.equals("0")) {
            return 0.0;
        }
        if (value.length() > 2) {
            double number = Double.parseDouble(value.substring(0, value.length() - 2));
            if (value.endsWith("mm")) {
                return number;
            }
            if (value.endsWith("cm")) {
                return number * 10.0;
            }
            if (value.endsWith("in")) {
                return number * 25.4;
            }
            if (value.endsWith("pt")) {
                return number * 2.834645669291339;
            }
            if (value.endsWith("pc")) {
                return number * 0.2362204724409449;
            }
            if (value.endsWith("px")) {
                return number * 0.264583333;
            }
            throw new IllegalArgumentException("Unit not recognized");
        }
        throw new IllegalArgumentException("A unit is needed");
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public Style getDefaultCellStyleCopy() {
        return ColumnStyle.cloneStyle(this.defaultCellStyle);
    }

    public Style getDefaultCellStyleDangerous() {
        return this.defaultCellStyle;
    }

    public void setDefaultCellStyle(Style defaultCellStyle) {
        if (defaultCellStyle == null) {
            throw new IllegalArgumentException("Default cell style cannot be null");
        }
        this.defaultCellStyle = ColumnStyle.cloneStyle(defaultCellStyle);
    }

    private static Style cloneStyle(Style style) {
        try {
            return (Style)style.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Style is not cloneable", e);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStyle that = (ColumnStyle)o;
        if (this.isHidden != that.isHidden) {
            return false;
        }
        if (!Objects.equals(this.defaultCellStyle, that.defaultCellStyle)) {
            return false;
        }
        return this.width != null ? this.width.equals(that.width) : that.width == null;
    }

    public int hashCode() {
        int result = this.width != null ? this.width.hashCode() : 0;
        result = 31 * result + (this.isHidden ? 1 : 0);
        result = 31 * result + (this.defaultCellStyle != null ? this.defaultCellStyle.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ColumnStyle{width=" + this.width + ", isHidden=" + this.isHidden + ", defaultCellStyle=" + this.defaultCellStyle + '}';
    }
}

