/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.FRegressionTest;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionTest;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.TRegressionTest;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.tramoseats.base.core.tramo.TramoModelBuilder;

public class DefaultRegressionTest
implements IRegressionModule {
    public static final double CVAL = 1.96;
    public static final double T0 = 2.0;
    public static final double T1 = 2.6;
    public static final double T2 = 2.2;
    private final ITradingDaysVariable td;
    private final ILengthOfPeriodVariable lp;
    private final IEasterVariable easter;
    private final IRegressionTest tdTest;
    private final IRegressionTest wdTest;
    private final IRegressionTest lpTest;
    private final IRegressionTest mhTest;
    private final IRegressionTest meanTest;
    private final double precision;
    private final boolean adjust;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultRegressionTest(Builder builder) {
        this.td = builder.td;
        this.lp = builder.lp;
        this.easter = builder.easter;
        this.tdTest = builder.joinTest ? new FRegressionTest(0.05) : new TRegressionTest(builder.t0td, builder.t1td);
        this.wdTest = new TRegressionTest(builder.twd);
        this.lpTest = new TRegressionTest(builder.t0td);
        this.mhTest = new TRegressionTest(builder.teaster);
        this.meanTest = builder.testMean ? new TRegressionTest(builder.tmean) : null;
        this.precision = builder.precision;
        this.adjust = builder.adjust;
    }

    private ModelDescription createTestModel(RegSarimaModelling current) {
        ModelDescription model = ModelDescription.copyOf((ModelDescription)current.getDescription());
        if (this.td != null) {
            model.addVariable(Variable.variable((String)"td", (ITsVariable)this.td, TramoModelBuilder.calendarAMI));
        }
        if (this.lp != null) {
            model.addVariable(Variable.variable((String)"lp", (ITsVariable)this.lp, TramoModelBuilder.calendarAMI));
        }
        if (this.easter != null) {
            model.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easter, TramoModelBuilder.calendarAMI));
        }
        return model;
    }

    public ProcessingResult test(RegSarimaModelling context) {
        int pos;
        Variable variable;
        if (this.td == null && this.lp == null && this.easter == null && this.meanTest == null) {
            return ProcessingResult.Unprocessed;
        }
        ModelDescription currentModel = context.getDescription();
        ModelDescription tmpModel = this.createTestModel(context);
        boolean changed = false;
        RegArimaModel regarima = tmpModel.regarima();
        IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.precision);
        RegArimaEstimation rslt = processor.process(regarima, currentModel.mapping());
        ConcentratedLikelihoodWithMissing ll = rslt.getConcentratedLikelihood();
        int nhp = tmpModel.getArimaSpec().freeParametersCount();
        boolean usetd = false;
        if (this.td != null && (variable = tmpModel.variable((ITsVariable)this.td)) != null && ModellingUtility.isAutomaticallyIdentified((Variable)variable)) {
            IRegressionTest test;
            pos = tmpModel.findPosition(variable.getCore());
            int dim = variable.getCore().dim();
            IRegressionTest iRegressionTest = test = dim == 1 ? this.wdTest : this.tdTest;
            if (test.accept(ll, nhp, pos, dim)) {
                usetd = true;
                currentModel.addVariable(Variable.variable((String)"td", (ITsVariable)this.td, TramoModelBuilder.calendarAMI));
                changed = true;
            }
        }
        if (this.lp != null && (variable = tmpModel.variable((ITsVariable)this.lp)) != null && ModellingUtility.isAutomaticallyIdentified((Variable)variable)) {
            pos = tmpModel.findPosition(variable.getCore());
            if (usetd && this.lpTest.accept(ll, nhp, pos, 1)) {
                if (this.adjust && tmpModel.isLogTransformation() && ll.coefficient(pos) > 0.0) {
                    currentModel.setPreadjustment(this.lp.getType());
                } else {
                    currentModel.addVariable(Variable.variable((String)"lp", (ITsVariable)this.lp, TramoModelBuilder.calendarAMI));
                }
                changed = true;
            }
        }
        if (this.easter != null && (variable = tmpModel.variable((ITsVariable)this.easter)) != null && ModellingUtility.isAutomaticallyIdentified((Variable)variable) && this.mhTest.accept(ll, nhp, pos = tmpModel.findPosition(variable.getCore()), 1)) {
            currentModel.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easter, TramoModelBuilder.calendarAMI));
            changed = true;
        }
        if (this.meanTest != null && regarima.isMean() && !this.meanTest.accept(ll, nhp, 0, 1)) {
            currentModel.setMean(false);
            changed = true;
        }
        if (changed) {
            context.clearEstimation();
        }
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    public static class Builder {
        private ITradingDaysVariable td;
        private ILengthOfPeriodVariable lp;
        private IEasterVariable easter;
        private double tmean = 1.96;
        private double teaster = 1.96;
        private double twd = 2.2;
        private double t0td = 2.0;
        private double t1td = 2.6;
        private double fpvalue = 0.05;
        private double precision = 1.0E-5;
        private boolean adjust = false;
        private boolean joinTest = false;
        private boolean testMean = true;

        public Builder tradingDays(ITradingDaysVariable td) {
            this.td = td;
            return this;
        }

        public Builder leapYear(ILengthOfPeriodVariable lp) {
            this.lp = lp;
            return this;
        }

        public Builder easter(IEasterVariable easter) {
            this.easter = easter;
            return this;
        }

        public Builder meanThreshold(double tmean) {
            this.tmean = tmean;
            return this;
        }

        public Builder easterThreshold(double teaster) {
            this.teaster = teaster;
            return this;
        }

        public Builder wdThreshold(double t) {
            this.twd = t;
            return this;
        }

        public Builder tdThreshold0(double t) {
            this.t0td = t;
            return this;
        }

        public Builder tdThreshold1(double t) {
            this.t1td = t;
            return this;
        }

        public Builder fPValue(double f) {
            this.fpvalue = f;
            return this;
        }

        public Builder useJoinTest(boolean join) {
            this.joinTest = join;
            return this;
        }

        public Builder testMean(boolean test) {
            this.testMean = test;
            return this;
        }

        public DefaultRegressionTest build() {
            return new DefaultRegressionTest(this);
        }

        public Builder estimationPrecision(double eps) {
            this.precision = eps;
            return this;
        }

        public Builder adjust(boolean adjust) {
            this.adjust = adjust;
            return this;
        }
    }
}

