/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.CalendarSigmaOption;
import jdplus.x13.base.api.x11.MsrTable;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.X11Kernel;
import jdplus.x13.base.core.x11.X11Utility;
import jdplus.x13.base.core.x11.extremevaluecorrector.IExtremeValuesCorrector;
import jdplus.x13.base.core.x11.extremevaluecorrector.PeriodSpecificExtremeValuesCorrector;
import jdplus.x13.base.core.x11.filter.AutomaticHenderson;
import jdplus.x13.base.core.x11.filter.DefaultSeasonalNormalizer;
import jdplus.x13.base.core.x11.filter.DummyFilter;
import jdplus.x13.base.core.x11.filter.MsrFilterSelection;
import jdplus.x13.base.core.x11.filter.MusgraveFilterFactory;
import jdplus.x13.base.core.x11.filter.X11SeasonalFilterProcessor;
import jdplus.x13.base.core.x11.filter.X11SeasonalFiltersFactory;
import jdplus.x13.base.core.x11.filter.X11TrendCycleFilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.AsymmetricEndPoints;
import lombok.Generated;

public class X11DStep {
    private static final double EPS = 1.0E-9;
    private DoubleSeq d1;
    private DoubleSeq d2;
    private DoubleSeq d4;
    private DoubleSeq d5;
    private DoubleSeq d6;
    private DoubleSeq d7;
    private DoubleSeq d8;
    private DoubleSeq d9;
    private DoubleSeq d9g;
    private DoubleSeq d9bis;
    private DoubleSeq d9_g_bis;
    private DoubleSeq d10;
    private DoubleSeq d10bis;
    private DoubleSeq d11;
    private DoubleSeq d11bis;
    private DoubleSeq d12;
    private DoubleSeq d13;
    private int d9msriter;
    private SeasonalFilterOption d9filter;
    private boolean d9default;
    private MsrTable d9msr;
    private int d2drop;
    private int finalHendersonFilterLength;
    private double iCRatio;
    private SeasonalFilterOption[] seasFilter;
    private DoubleSeq refSeries;

    public void process(DoubleSeq refSeries, DoubleSeq input, X11Context context) {
        this.refSeries = refSeries;
        this.d1Step(context, input);
        this.d2Step(context);
        this.d4Step(context);
        this.d5Step(context);
        this.d6Step(context);
        this.d7Step(context);
        this.d8Step(context);
        this.d9Step(context);
        this.dFinalStep(context);
    }

    private void d1Step(X11Context context, DoubleSeq input) {
        this.d1 = this.d1(context, input);
    }

    protected DoubleSeq d1(X11Context context, DoubleSeq input) {
        return context.remove(this.refSeries, input);
    }

    private void d2Step(X11Context context) {
        SymmetricFilter filter = X11TrendCycleFilterFactory.makeTrendFilter(context.getPeriod());
        this.d2drop = filter.length() / 2;
        double[] x = X11Kernel.table(this.d1.length() - 2 * this.d2drop, Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)0, (int)x.length);
        filter.apply(this.d1, (DoubleSeq.Mutable)out);
        this.d2 = DoubleSeq.of((double[])x);
    }

    private void d4Step(X11Context context) {
        this.d4 = context.remove(this.d1.drop(this.d2drop, this.d2drop), this.d2);
    }

    private void d5Step(X11Context context) {
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getInitialSeasonalFilter());
            DoubleSeq d5a = processor.process(this.d4, context.getPosition(this.d2drop));
            this.d5 = DefaultSeasonalNormalizer.normalize(d5a, this.d2drop, context);
        } else {
            this.d5 = DummyFilter.filter(context.isMultiplicative(), this.d4);
        }
    }

    private void d6Step(X11Context context) {
        this.d6 = this.d6(context);
    }

    protected DoubleSeq d6(X11Context context) {
        return context.remove(this.d1, this.d5);
    }

    private void d7Step(X11Context context) {
        SymmetricFilter filter;
        if (context.isAutomaticHenderson()) {
            double icr = AutomaticHenderson.calcICR(context, this.d6);
            int filterLength = AutomaticHenderson.selectFilter(icr, context.getPeriod());
            filter = context.trendFilter(filterLength);
        } else {
            filter = context.trendFilter();
        }
        int ndrop = filter.length() / 2;
        double[] x = X11Kernel.table(this.d6.length(), Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        filter.apply(this.d6, (DoubleSeq.Mutable)out);
        double r = MusgraveFilterFactory.findR(filter.length(), context.getPeriod());
        IFiniteFilter[] asymmetricFilter = context.asymmetricTrendFilters(filter, r);
        AsymmetricEndPoints aep = new AsymmetricEndPoints(asymmetricFilter, 0);
        aep.process(this.d6, DataBlock.of((double[])x));
        this.d7 = DoubleSeq.of((double[])x);
        if (context.isMultiplicative()) {
            this.d7 = X11Context.makePositivity(this.d7);
        }
    }

    private void d8Step(X11Context context) {
        this.d8 = this.d8(context);
    }

    protected DoubleSeq d8(X11Context context) {
        return context.remove(this.refSeries, this.d7);
    }

    private void d9Step(X11Context context) {
        IExtremeValuesCorrector ecorr = context.getExtremeValuesCorrector();
        if (ecorr instanceof PeriodSpecificExtremeValuesCorrector && context.getCalendarSigma() != CalendarSigmaOption.Signif) {
            this.d9 = ecorr.computeCorrections(this.d8, true);
            this.d9_g_bis = this.d9g = ecorr.applyCorrections(this.d8, this.d9);
        } else {
            this.d9bis = context.remove(this.d1, this.d7);
            DoubleSeq d9temp = DoubleSeq.onMapping((int)this.d9bis.length(), i -> Math.abs(this.d9bis.get(i) - this.d8.get(i)));
            this.d9 = DoubleSeq.onMapping((int)d9temp.length(), i -> d9temp.get(i) < 1.0E-9 ? Double.NaN : this.d9bis.get(i));
            this.d9_g_bis = this.d9bis;
        }
    }

    private void dFinalStep(X11Context context) {
        SymmetricFilter hfilter;
        if (context.isSeasonal()) {
            this.seasFilter = context.getFinalSeasonalFilter();
            if (context.isMSR()) {
                MsrFilterSelection msr = this.getMsrFilterSelection();
                SeasonalFilterOption msrFilter = msr.doMSR(this.d9_g_bis, context);
                this.d9msriter = msr.getIterCount();
                this.d9filter = msrFilter;
                Arrays.fill(this.seasFilter, msrFilter);
            }
            this.d9msr = X11Utility.defaultMsrTable(this.d9_g_bis.drop(context.getBackcastHorizon(), context.getForecastHorizon()), context.getPeriod(), context.getPosition(context.getBackcastHorizon()), context.getMode());
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), this.seasFilter);
            this.d10bis = processor.process(this.d9_g_bis, context.getPosition(0));
            this.d10 = DefaultSeasonalNormalizer.normalize(this.d10bis, 0, context);
        } else {
            this.d10 = this.d10bis = DummyFilter.filter(context.isMultiplicative(), this.d9_g_bis);
        }
        this.d11bis = this.d11bis(context);
        this.iCRatio = AutomaticHenderson.calcICR(context, this.d11bis);
        if (context.isAutomaticHenderson()) {
            int filterLength = AutomaticHenderson.selectFilter(this.iCRatio, context.getPeriod());
            hfilter = context.trendFilter(filterLength);
        } else {
            hfilter = context.trendFilter();
        }
        this.finalHendersonFilterLength = hfilter.length();
        int ndrop = hfilter.length() / 2;
        double[] x = X11Kernel.table(this.d11bis.length(), Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        hfilter.apply(this.d11bis, (DoubleSeq.Mutable)out);
        double r = MusgraveFilterFactory.findR(hfilter.length(), context.getPeriod());
        IFiniteFilter[] asymmetricFilter = context.asymmetricTrendFilters(hfilter, r);
        AsymmetricEndPoints aep = new AsymmetricEndPoints(asymmetricFilter, 0);
        aep.process(this.d11bis, DataBlock.of((double[])x));
        this.d12 = DoubleSeq.of((double[])x);
        if (context.isMultiplicative()) {
            this.d12 = X11Context.makePositivity(this.d12);
        }
        this.d11 = this.d11(context);
        this.d13 = context.remove(this.d11, this.d12);
    }

    protected MsrFilterSelection getMsrFilterSelection() {
        return new MsrFilterSelection();
    }

    protected DoubleSeq d11(X11Context context) {
        return context.remove(this.refSeries, this.d10);
    }

    protected DoubleSeq d11bis(X11Context context) {
        return context.remove(this.d1, this.d10);
    }

    @Generated
    public DoubleSeq getD1() {
        return this.d1;
    }

    @Generated
    public DoubleSeq getD2() {
        return this.d2;
    }

    @Generated
    public DoubleSeq getD4() {
        return this.d4;
    }

    @Generated
    public DoubleSeq getD5() {
        return this.d5;
    }

    @Generated
    public DoubleSeq getD6() {
        return this.d6;
    }

    @Generated
    public DoubleSeq getD7() {
        return this.d7;
    }

    @Generated
    public DoubleSeq getD8() {
        return this.d8;
    }

    @Generated
    public DoubleSeq getD9() {
        return this.d9;
    }

    @Generated
    public DoubleSeq getD9g() {
        return this.d9g;
    }

    @Generated
    public DoubleSeq getD9bis() {
        return this.d9bis;
    }

    @Generated
    public DoubleSeq getD9_g_bis() {
        return this.d9_g_bis;
    }

    @Generated
    public DoubleSeq getD10() {
        return this.d10;
    }

    @Generated
    public DoubleSeq getD10bis() {
        return this.d10bis;
    }

    @Generated
    public DoubleSeq getD11() {
        return this.d11;
    }

    @Generated
    public DoubleSeq getD11bis() {
        return this.d11bis;
    }

    @Generated
    public DoubleSeq getD12() {
        return this.d12;
    }

    @Generated
    public DoubleSeq getD13() {
        return this.d13;
    }

    @Generated
    public int getD9msriter() {
        return this.d9msriter;
    }

    @Generated
    public SeasonalFilterOption getD9filter() {
        return this.d9filter;
    }

    @Generated
    public boolean isD9default() {
        return this.d9default;
    }

    @Generated
    public MsrTable getD9msr() {
        return this.d9msr;
    }

    @Generated
    public int getD2drop() {
        return this.d2drop;
    }

    @Generated
    public int getFinalHendersonFilterLength() {
        return this.finalHendersonFilterLength;
    }

    @Generated
    public double getICRatio() {
        return this.iCRatio;
    }

    @Generated
    public SeasonalFilterOption[] getSeasFilter() {
        return this.seasFilter;
    }

    @Generated
    public DoubleSeq getRefSeries() {
        return this.refSeries;
    }
}

