/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.stream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsProvider;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataMoniker;
import jdplus.toolkit.base.tsp.stream.DataSetTs;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.NonNull;

public final class TsStreamAsProvider
implements TsProvider {
    private final String providerName;
    private final HasTsStream htc;
    private final HasDataMoniker hdm;
    private final Runnable cacheCleaner;

    @NonNull
    public static TsStreamAsProvider of(@NonNull String providerName, @NonNull HasTsStream hdc, @NonNull HasDataMoniker hdm, @NonNull Runnable cacheCleaner) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (hdc == null) {
            throw new NullPointerException("hdc is marked non-null but is null");
        }
        if (hdm == null) {
            throw new NullPointerException("hdm is marked non-null but is null");
        }
        if (cacheCleaner == null) {
            throw new NullPointerException("cacheCleaner is marked non-null but is null");
        }
        return new TsStreamAsProvider(providerName, hdc, hdm, cacheCleaner);
    }

    private TsStreamAsProvider(String providerName, HasTsStream htc, HasDataMoniker hdm, Runnable cacheCleaner) {
        this.providerName = Objects.requireNonNull(providerName, "providerName");
        this.htc = Objects.requireNonNull(htc, "HasTsCursor");
        this.hdm = Objects.requireNonNull(hdm, "HasDataMoniker");
        this.cacheCleaner = Objects.requireNonNull(cacheCleaner, "cacheCleaner");
    }

    public void clearCache() {
        this.cacheCleaner.run();
    }

    public void close() {
        this.clearCache();
    }

    @NonNull
    public TsCollection getTsCollection(@NonNull TsMoniker moniker, @NonNull TsInformationType type) throws IOException, IllegalArgumentException {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.getSource(), moniker);
        TsCollection.Builder result = TsCollection.builder().moniker(moniker).type(type);
        Optional<DataSource> dataSource = this.hdm.toDataSource(moniker);
        if (dataSource.isPresent()) {
            this.fill(result, dataSource.orElseThrow(), type);
            return result.build();
        }
        Optional<DataSet> dataSet = this.hdm.toDataSet(moniker);
        if (dataSet.filter(TsStreamAsProvider::isCollection).isPresent()) {
            this.fill(result, dataSet.orElseThrow(), type);
            return result.build();
        }
        throw new IllegalArgumentException("Invalid moniker");
    }

    @NonNull
    public Ts getTs(@NonNull TsMoniker moniker, @NonNull TsInformationType type) throws IOException, IllegalArgumentException {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.getSource(), moniker);
        Ts.Builder result = Ts.builder().moniker(moniker).type(type);
        Optional<DataSet> dataSet = this.hdm.toDataSet(moniker);
        if (dataSet.filter(TsStreamAsProvider::isSeries).isPresent()) {
            this.fill(result, dataSet.orElseThrow(), type);
            return result.build();
        }
        throw new IllegalArgumentException("Invalid moniker");
    }

    @NonNull
    public String getSource() {
        return this.providerName;
    }

    public boolean isAvailable() {
        return true;
    }

    private static boolean isCollection(DataSet dataSet) {
        return DataSet.Kind.COLLECTION.equals((Object)dataSet.getKind());
    }

    private static boolean isSeries(DataSet dataSet) {
        return DataSet.Kind.SERIES.equals((Object)dataSet.getKind());
    }

    private void fill(TsCollection.Builder info, DataSource dataSource, TsInformationType type) throws IOException {
        try (Stream<DataSetTs> stream = this.htc.getData(dataSource, type);){
            this.fill(info, stream, type);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    private void fill(TsCollection.Builder info, DataSet dataSet, TsInformationType type) throws IOException {
        try (Stream<DataSetTs> stream = this.htc.getData(dataSet, type);){
            this.fill(info, stream, type);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    private void fill(Ts.Builder builder, DataSet dataSet, TsInformationType type) throws IOException {
        try (Stream<DataSetTs> stream = this.htc.getData(dataSet, type);){
            DataSetTs single = stream.findFirst().orElseThrow(() -> new IOException("Missing time series"));
            this.fill(builder, single, type);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    private void fill(TsCollection.Builder builder, Stream<DataSetTs> cursor, TsInformationType type) {
        if (type.encompass(TsInformationType.MetaData)) {
            // empty if block
        }
        cursor.map(tsInfo -> {
            Ts.Builder item = Ts.builder();
            item.moniker(this.hdm.toMoniker(tsInfo.getId())).type(type);
            this.fill(item, (DataSetTs)tsInfo, type);
            return item.build();
        }).forEach(arg_0 -> ((TsCollection.Builder)builder).item(arg_0));
    }

    private void fill(Ts.Builder builder, DataSetTs tsInfo, TsInformationType type) {
        builder.clearMeta();
        builder.name(tsInfo.getLabel());
        if (type.encompass(TsInformationType.MetaData)) {
            builder.meta(tsInfo.getMeta());
        }
        if (type.encompass(TsInformationType.Data)) {
            builder.data(tsInfo.getData());
        }
    }
}

