/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.arima;

import java.util.Arrays;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParameterType;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SarimaSpec
implements Validatable<SarimaSpec> {
    private final Validator validator;
    private final int period;
    private final int d;
    private final int bd;
    @NonNull
    private final Parameter[] phi;
    @NonNull
    private final Parameter[] theta;
    @NonNull
    private final Parameter[] bphi;
    @NonNull
    private final Parameter[] btheta;
    private static final Parameter[] EMPTY = new Parameter[0];
    private static final SarimaSpec AIRLINE = new SarimaSpec(null, 0, 1, 1, EMPTY, Parameter.make(1), EMPTY, Parameter.make(1));
    private static final SarimaSpec WN = new SarimaSpec(null, 0, 0, 0, EMPTY, EMPTY, EMPTY, EMPTY);

    @Override
    public SarimaSpec validate() throws IllegalArgumentException {
        if (this.validator != null) {
            this.validator.checkP(this.getP());
            this.validator.checkD(this.getD());
            this.validator.checkQ(this.getQ());
            this.validator.checkBp(this.getBp());
            this.validator.checkBd(this.getBd());
            this.validator.checkBq(this.getBq());
        }
        return this;
    }

    public Parameter[] getPhi() {
        return this.phi == EMPTY ? EMPTY : (Parameter[])this.phi.clone();
    }

    public Parameter[] getBphi() {
        return this.bphi == EMPTY ? EMPTY : (Parameter[])this.bphi.clone();
    }

    public Parameter[] getTheta() {
        return this.theta == EMPTY ? EMPTY : (Parameter[])this.theta.clone();
    }

    public Parameter[] getBtheta() {
        return this.btheta == EMPTY ? EMPTY : (Parameter[])this.btheta.clone();
    }

    public static SarimaSpec airline() {
        return AIRLINE;
    }

    public static SarimaSpec whiteNoise() {
        return WN;
    }

    public int getP() {
        return this.phi.length;
    }

    public int getQ() {
        return this.theta.length;
    }

    public int getBp() {
        return this.bphi.length;
    }

    public int getBq() {
        return this.btheta.length;
    }

    public boolean isAirline() {
        return this.getP() == 0 && this.d == 1 && this.getQ() == 1 && this.getBp() == 0 && this.bd == 1 && this.getBq() == 1;
    }

    public int parametersCount() {
        return this.phi.length + this.bphi.length + this.theta.length + this.btheta.length;
    }

    public int freeParametersCount() {
        return Parameter.freeParametersCount(this.phi) + Parameter.freeParametersCount(this.bphi) + Parameter.freeParametersCount(this.theta) + Parameter.freeParametersCount(this.btheta);
    }

    public boolean hasFixedParameters() {
        return !Parameter.isFree(this.phi) || !Parameter.isFree(this.bphi) || !Parameter.isFree(this.theta) || !Parameter.isFree(this.btheta);
    }

    public boolean hasFreeParameters() {
        return Parameter.hasFreeParameters(this.phi) || Parameter.hasFreeParameters(this.bphi) || Parameter.hasFreeParameters(this.theta) || Parameter.hasFreeParameters(this.btheta);
    }

    public boolean hasEstimatedParameters() {
        return Parameter.hasParameters(this.phi, ParameterType.Estimated) || Parameter.hasParameters(this.bphi, ParameterType.Estimated) || !Parameter.hasParameters(this.theta, ParameterType.Estimated) || Parameter.hasParameters(this.btheta, ParameterType.Estimated);
    }

    public boolean isUndefined() {
        return Parameter.isDefault(this.phi) && Parameter.isDefault(this.theta) && Parameter.isDefault(this.bphi) && Parameter.isDefault(this.btheta);
    }

    public boolean isDefined() {
        return Parameter.isDefined(this.phi) && Parameter.isDefined(this.theta) && Parameter.isDefined(this.bphi) && Parameter.isDefined(this.btheta);
    }

    public SarimaSpec withPeriod(int period) {
        if (this.period == period) {
            return this;
        }
        if (period == 1) {
            return new SarimaSpec(null, 1, this.d, 0, this.phi, this.theta, EMPTY, EMPTY);
        }
        return new SarimaSpec(null, period, this.d, this.bd, this.phi, this.theta, this.bphi, this.btheta);
    }

    public SarimaSpec resetParameters(SarimaSpec ref) {
        return (SarimaSpec)this.toBuilder().reset(ref).build();
    }

    public SarimaSpec freeParameters(SarimaSpec ref) {
        return (SarimaSpec)this.toBuilder().free(ref).build();
    }

    public SarimaSpec fixParameters() {
        if (!this.hasFreeParameters()) {
            return this;
        }
        return (SarimaSpec)this.toBuilder().fix().build();
    }

    public SarimaOrders orders() {
        SarimaOrders spec = new SarimaOrders(this.period);
        spec.setP(this.getP());
        spec.setD(this.d);
        spec.setQ(this.getQ());
        if (this.period != 1) {
            spec.setBp(this.getBp());
            spec.setBd(this.bd);
            spec.setBq(this.getBq());
        }
        return spec;
    }

    public int getDifferencingOrder() {
        return this.d + this.bd * this.period;
    }

    @Generated
    SarimaSpec(Validator validator, int period, int d, int bd, @NonNull Parameter[] phi, @NonNull Parameter[] theta, @NonNull Parameter[] bphi, @NonNull Parameter[] btheta) {
        if (phi == null) {
            throw new NullPointerException("phi is marked non-null but is null");
        }
        if (theta == null) {
            throw new NullPointerException("theta is marked non-null but is null");
        }
        if (bphi == null) {
            throw new NullPointerException("bphi is marked non-null but is null");
        }
        if (btheta == null) {
            throw new NullPointerException("btheta is marked non-null but is null");
        }
        this.validator = validator;
        this.period = period;
        this.d = d;
        this.bd = bd;
        this.phi = phi;
        this.theta = theta;
        this.bphi = bphi;
        this.btheta = btheta;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().validator(this.validator).period(this.period).d(this.d).bd(this.bd).phi(this.phi).theta(this.theta).bphi(this.bphi).btheta(this.btheta);
    }

    @Generated
    public Validator getValidator() {
        return this.validator;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public int getD() {
        return this.d;
    }

    @Generated
    public int getBd() {
        return this.bd;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SarimaSpec)) {
            return false;
        }
        SarimaSpec other = (SarimaSpec)o;
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.getD() != other.getD()) {
            return false;
        }
        if (this.getBd() != other.getBd()) {
            return false;
        }
        Validator this$validator = this.getValidator();
        Validator other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPhi(), other.getPhi())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTheta(), other.getTheta())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBphi(), other.getBphi())) {
            return false;
        }
        return Arrays.deepEquals(this.getBtheta(), other.getBtheta());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeriod();
        result = result * 59 + this.getD();
        result = result * 59 + this.getBd();
        Validator $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPhi());
        result = result * 59 + Arrays.deepHashCode(this.getTheta());
        result = result * 59 + Arrays.deepHashCode(this.getBphi());
        result = result * 59 + Arrays.deepHashCode(this.getBtheta());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "SarimaSpec(validator=" + String.valueOf(this.getValidator()) + ", period=" + this.getPeriod() + ", d=" + this.getD() + ", bd=" + this.getBd() + ", phi=" + Arrays.deepToString(this.getPhi()) + ", theta=" + Arrays.deepToString(this.getTheta()) + ", bphi=" + Arrays.deepToString(this.getBphi()) + ", btheta=" + Arrays.deepToString(this.getBtheta()) + ")";
    }

    public static interface Validator {
        public void checkP(int var1);

        public void checkD(int var1);

        public void checkQ(int var1);

        public void checkBp(int var1);

        public void checkBd(int var1);

        public void checkBq(int var1);
    }

    public static class Builder
    implements Validatable.Builder<SarimaSpec> {
        @Generated
        private Validator validator;
        @Generated
        private int period;
        @Generated
        private int d;
        @Generated
        private int bd;
        @Generated
        private Parameter[] phi = EMPTY;
        @Generated
        private Parameter[] theta = EMPTY;
        @Generated
        private Parameter[] bphi = EMPTY;
        @Generated
        private Parameter[] btheta = EMPTY;

        private Builder() {
        }

        public Builder p(int value) {
            this.phi = value == 0 ? EMPTY : Parameter.make(value);
            return this;
        }

        public Builder d(int value) {
            this.d = value;
            return this;
        }

        public Builder q(int value) {
            this.theta = value == 0 ? EMPTY : Parameter.make(value);
            return this;
        }

        public Builder bp(int value) {
            this.bphi = value == 0 ? EMPTY : Parameter.make(value);
            return this;
        }

        public Builder bd(int value) {
            this.bd = value;
            return this;
        }

        public Builder bq(int value) {
            this.btheta = value == 0 ? EMPTY : Parameter.make(value);
            return this;
        }

        public Builder phi(Parameter[] value) {
            this.phi = value == null || value.length == 0 ? EMPTY : (Parameter[])value.clone();
            return this;
        }

        public Builder theta(Parameter[] value) {
            this.theta = value == null || value.length == 0 ? EMPTY : (Parameter[])value.clone();
            return this;
        }

        public Builder bphi(Parameter[] value) {
            this.bphi = value == null || value.length == 0 ? EMPTY : (Parameter[])value.clone();
            return this;
        }

        public Builder btheta(Parameter[] value) {
            this.btheta = value == null || value.length == 0 ? EMPTY : (Parameter[])value.clone();
            return this;
        }

        public Builder airline() {
            this.phi = EMPTY;
            this.bphi = EMPTY;
            this.theta = Parameter.make(1);
            this.btheta = Parameter.make(1);
            this.d = 1;
            this.bd = 1;
            return this;
        }

        Builder free(SarimaSpec ref) {
            if (ref == null) {
                this.phi = Parameter.freeParameters(this.phi);
                this.bphi = Parameter.freeParameters(this.bphi);
                this.theta = Parameter.freeParameters(this.theta);
                this.btheta = Parameter.freeParameters(this.btheta);
            } else {
                this.phi = Parameter.freeParameters(this.phi, ref.phi);
                this.bphi = Parameter.freeParameters(this.bphi, ref.bphi);
                this.theta = Parameter.freeParameters(this.theta, ref.theta);
                this.btheta = Parameter.freeParameters(this.btheta, ref.btheta);
            }
            return this;
        }

        Builder fix() {
            this.phi = Parameter.fixParameters(this.phi);
            this.bphi = Parameter.fixParameters(this.bphi);
            this.theta = Parameter.fixParameters(this.theta);
            this.btheta = Parameter.fixParameters(this.btheta);
            return this;
        }

        Builder reset(SarimaSpec ref) {
            if (ref == null) {
                this.phi = Parameter.resetParameters(this.phi);
                this.bphi = Parameter.resetParameters(this.bphi);
                this.theta = Parameter.resetParameters(this.theta);
                this.btheta = Parameter.resetParameters(this.btheta);
            } else {
                this.phi = Parameter.resetParameters(this.phi, ref.phi);
                this.bphi = Parameter.resetParameters(this.bphi, ref.bphi);
                this.theta = Parameter.resetParameters(this.theta, ref.theta);
                this.btheta = Parameter.resetParameters(this.btheta, ref.btheta);
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder validator(Validator validator) {
            this.validator = validator;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder period(int period) {
            this.period = period;
            return this;
        }

        @Override
        @Generated
        public @org.jspecify.annotations.NonNull SarimaSpec buildWithoutValidation() {
            return new SarimaSpec(this.validator, this.period, this.d, this.bd, this.phi, this.theta, this.bphi, this.btheta);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SarimaSpec.Builder(validator=" + String.valueOf(this.validator) + ", period=" + this.period + ", d=" + this.d + ", bd=" + this.bd + ", phi=" + Arrays.deepToString(this.phi) + ", theta=" + Arrays.deepToString(this.theta) + ", bphi=" + Arrays.deepToString(this.bphi) + ", btheta=" + Arrays.deepToString(this.btheta) + ")";
        }
    }
}

