## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----echo = FALSE, message = FALSE--------------------------------------------
require(scaRabee)

## ----eval = FALSE-------------------------------------------------------------
#  require(scaRabee)
#  scarabee.new(name='myanalysis',
#               path = 'some/target/directory/',
#               type = 'simulation',
#               method = 'population',
#               template = 'ode')

## ----eval=FALSE---------------------------------------------------------------
#  v <- rbind(ones(1,ntime))

## ----eval=FALSE---------------------------------------------------------------
#  v <- rbind((SD^2)*ones(1,ntime))

## ----eval=FALSE---------------------------------------------------------------
#  v <- rbind((CV^2)*(y[1,]^2))

## ----eval=FALSE---------------------------------------------------------------
#  v <- rbind((SD^2)*ones(1,ntime) + (CV^2)*(y[1,]^2))

## ----echo = FALSE, fig.height=4.5, fig.width=5, fig.dpi=300-------------------
par( mfrow = c(2, 2), mar = c(4, 4, 1.5, 0.5) )

plot(
  x = c(0, 10, 10, 20, 20, 45),
  y = c(100, 100, 0, 0, 50, 50),
  col = 'blue',
  type = 'l',
  xlab = 'Time',
  ylab = 'Infusion rate in state 1'
)

plot(
  x = c(0, 45),
  y = c(0, 0),
  col = 'blue',
  type = 'l',
  xlab = 'Time',
  ylab = 'Infusion rate in state 2',
  ylim = c(-7, 107)
)

plot(
  x = c(0, 10, 20, 20, 45),
  y = c(0, 1000, 1000, 1250, 2500),
  col = 'blue',
  type = 'l',
  xlab = 'Time',
  ylab = 'State 1'
)

plot(
  x = c(0, 15, 15, 45),
  y = c(0, 0, 200, 200),
  col = 'blue',
  type = 'l',
  xlab = 'Time',
  ylab = 'State 2'
)

## ----eval=FALSE---------------------------------------------------------------
#  demo(ex, package = 'scaRabee', echo = FALSE)

