/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.util.Vector;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.XMLHelper;
import org.rosuda.deducer.widgets.param.Param;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RFunction
extends Param {
    protected Vector params = new Vector();
    protected String paramName = "";
    public static String VIEW_RFUNCTION = "org.rosuda.deducer.widgets.param.DefaultRFunctionView";

    public RFunction() {
        this.view = VIEW_RFUNCTION;
    }

    public RFunction(String string) {
        this.setName(string);
        this.view = VIEW_RFUNCTION;
    }

    public Vector getParams() {
        return this.params;
    }

    public void setParams(Vector vector) {
        this.params = vector;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Object clone() {
        RFunction rFunction = new RFunction();
        for (int i = 0; i < this.params.size(); ++i) {
            rFunction.params.add(((Param)this.params.get(i)).clone());
        }
        rFunction.name = this.name;
        rFunction.view = this.view;
        rFunction.requiresVariableSelector = this.requiresVariableSelector;
        rFunction.required = this.required;
        return rFunction;
    }

    public String checkValid() {
        for (int i = 0; i < this.params.size(); ++i) {
            Param param = (Param)this.params.get(i);
            if (param instanceof RFunction) {
                String string = ((RFunction)param).checkValid();
                if (string == null) continue;
                return string;
            }
            if (!param.isRequired() || param.hasValidEntry()) continue;
            return "'" + param.getTitle() + "' is required. Please enter a value.";
        }
        return null;
    }

    public String getCall() {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.params.size(); ++n) {
            Param param = (Param)this.params.get(n);
            String[] stringArray = param.getParamCalls();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        for (n = vector.size() - 1; n > 0; --n) {
            for (int i = n - 1; i >= 0; --i) {
                if (!vector.get(n).equals(vector.get(i))) continue;
                vector.remove(i);
            }
        }
        String string = Deducer.makeRCollection(vector, this.name, false);
        return string;
    }

    public void add(Param param) {
        this.params.add(param);
    }

    public Param get(int n) {
        return (Param)this.params.get(n);
    }

    public void remove(Param param) {
        this.params.remove(param);
    }

    @Override
    public Element toXML() {
        try {
            Element element = super.toXML();
            Document document = element.getOwnerDocument();
            if (this.paramName != null) {
                element.setAttribute("paramName", this.paramName);
            }
            for (int i = 0; i < this.params.size(); ++i) {
                Param param = (Param)this.params.get(i);
                Element element2 = param.toXML();
                Node node = document.importNode(element2, true);
                element.appendChild(node);
            }
            element.setAttribute("view", this.view);
            element.setAttribute("className", "org.rosuda.deducer.widgets.param.RFunction");
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void setFromXML(Element element) {
        super.setFromXML(element);
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.widgets.param.RFunction")) {
            System.out.println("Error RFunction: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.view = element.hasAttribute("view") ? element.getAttribute("view") : VIEW_RFUNCTION;
        this.paramName = element.hasAttribute("paramName") ? element.getAttribute("paramName") : null;
        this.params = new Vector();
        Vector vector = XMLHelper.getChildrenElementsByTag(element, "Param");
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            string = element2.getAttribute("className");
            Param param = Param.makeParam(string);
            param.setFromXML(element2);
            this.params.add(param);
        }
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public String[] getParamCalls() {
        return new String[]{this.getCall()};
    }

    @Override
    public Object getValue() {
        return this.params;
    }

    @Override
    public void setDefaultValue(Object object) {
    }

    @Override
    public void setValue(Object object) {
        this.params = (Vector)object;
    }
}

