cpp <- list.files(
  "src",
  pattern = "\\.cpp$",
  recursive = TRUE,
  full.names = TRUE
)

# strip leading "src/" (MacOs/ Linux) or leading "src\\" (Windows)
cpp <- sub("^src[\\\\/]", "", cpp)

con <- file(file.path("src", "sources.mk"), open = "w")

writeLines(c(
  "# ------------------------------------------------------------------",
  "# THIS FILE IS AUTO-GENERATED - DO NOT EDIT",
  "# Generated by configure",
  "# To add C++ code, place .cpp files anywhere under src/",
  "# ------------------------------------------------------------------",
  "SOURCES = \\"
), con)

writeLines(paste0("  ", cpp, " \\"), con)
writeLines("", con)

close(con)

