## ----setup, echo=FALSE, warning=FALSE, message=FALSE--------------------------
library(rfars)
library(dplyr)
library(ggplot2)
library(magrittr)
library(tidyr)

## ----warning=FALSE, eval=F----------------------------------------------------
#  mydata <- rfars::get_gescrss(years=2023, proceed = TRUE)
#  my_events <- mydata$events

## ----results='asis', eval=F---------------------------------------------------
#  knitr::kable(filter(my_events, casenum == "202304741191")format = "html")

## ----results='asis', echo=F---------------------------------------------------
vignette_data <- rfars:::vignette_data
knitr::kable(vignette_data$events_1, format = "html")

## ----eval=F, fig.width=12, fig.height=7---------------------------------------
#  events_temp <-
#    my_events %>%
#    group_by(casenum, veh_no) %>%
#    mutate(
#      veventnum = as.numeric(as.character(veventnum)),
#      lasteventnum = max(veventnum)
#    ) %>%
#    ungroup() %>%
#    filter(soe=="Pedestrian" & veventnum==lasteventnum) %>%
#    distinct(casenum, veh_no, year, lasteventnum) %>%
#    left_join(events_data$events) %>%
#    left_join(
#      distinct(events_data$flat, year, region, casenum, max_sev, weight) %>%
#        mutate_at(c("casenum", "year"), as.character) %>%
#        mutate_at(c("region"), word)
#    ) %>%
#    mutate(
#      fatal = factor(ifelse(max_sev != "Fatal Injury (K)", "Non-Fatal", "Fatal"), ordered = T),
#      veventnum = as.numeric(as.character(veventnum)),
#      eventnum = as.factor(veventnum - lasteventnum),
#      soe = str_replace_all(soe, "Motor Vehicle In-Transport Strikes or is Struck by Cargo, Persons or Objects Set-in-Motion from/by Another Motor Vehicle In Transport", "Motor Vehicle In-Transport Strikes or is Struck by Something")
#    )
#  
#  sequences <-
#    events_temp %>%
#    arrange(casenum, eventnum) %>%
#    distinct(casenum, region, eventnum, soe, fatal) %>%
#    group_by(casenum, region, fatal) %>%
#    summarize(sequence = paste0(soe, collapse = " THEN "), .groups = "drop")
#  
#  sequences_meta <-
#    sequences %>%
#    group_by(sequence, region, fatal) %>%
#    summarize(sequence_n = n(), .groups = "drop") %>%
#    arrange(-sequence_n) %>%
#    mutate(sequence_num = row_number()) %>%
#    filter(sequence_n > 1)
#  
#  sequence_event_counts <-
#    inner_join(events_temp, sequences) %>%
#    group_by(sequence, soe, eventnum, region, fatal) %>%
#    summarize(n=sum(weight)) %>%
#    filter(sequence %in% unique(sequences_meta$sequence))
#  
#  event_counts <-
#    sequence_event_counts %>%
#    group_by(soe, eventnum, region, fatal) %>%
#    summarize(n=sum(n))
#  
#  sequence_event_counts %>%
#    ggplot(aes(x=eventnum, y=soe, group=sequence)) +
#    geom_line(aes(linewidth = log(n)), alpha=.6) +
#    geom_label(
#      inherit.aes = F,
#      data = event_counts,
#      aes(x=eventnum, y=soe, size=log(n), label = scales::comma(n, accuracy = 1))
#    ) +
#    scale_x_discrete(expand = expansion(add=c(.2, .6))) +
#    facet_grid(fatal~region, scales = "free_y", space = "free_y") +
#    guides(size="none", linewidth="none") +
#    labs(
#      x = "Event Number (Relative to Last Event)",
#      y = NULL,
#      title = "Crash Sequences",
#      subtitle = "Pedestrian crashes in 2023"
#    ) +
#    theme(
#      axis.ticks = element_blank(),
#      strip.text.y.right = element_text(angle=0)
#    )

## ----echo=F, fig.width=12, fig.height=7---------------------------------------
vignette_data$events_2$sequence_event_counts %>%
  ggplot(aes(x=eventnum, y=soe, group=sequence)) +
  geom_line(aes(linewidth = log(n)), alpha=.6) +
  geom_label(
    inherit.aes = F,
    data = vignette_data$events_2$event_counts,
    aes(x=eventnum, y=soe, size=log(n), label = scales::comma(n, accuracy = 1))
  ) +
  scale_x_discrete(expand = expansion(add=c(.2, .6))) +
  facet_grid(fatal~region, scales = "free_y", space = "free_y") +
  guides(size="none", linewidth="none") +
  labs(
    x = "Event Number (Relative to Last Event)",
    y = NULL,
    title = "Crash Sequences",
    subtitle = "Pedestrian crashes in 2023"
  ) +
  theme(
    axis.ticks = element_blank(),
    strip.text.y.right = element_text(angle=0)
  )

