/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.util.Comparator;
import jdplus.toolkit.base.api.util.WeightedItem;

public final class WeightedItems<T>
implements Cloneable {
    private ArrayList<WeightedItem<T>> items = new ArrayList();

    public List<WeightedItem<T>> items() {
        return Collections.unmodifiableList(this.items);
    }

    public void clear() {
        this.items.clear();
    }

    public int getCount() {
        return this.items.size();
    }

    public WeightedItem<T> get(int idx) {
        return this.items.get(idx);
    }

    public void add(WeightedItem<T> item) {
        this.items.add(item);
    }

    public void add(Collection<WeightedItem<T>> items) {
        this.items.addAll(items);
    }

    public void removeAt(int pos) {
        this.items.remove(pos);
    }

    public WeightedItems<T> normalize() {
        double sum = this.getSumWeights();
        if (sum == 0.0) {
            return null;
        }
        WeightedItems<T> nw = new WeightedItems<T>();
        for (WeightedItem<T> item : this.items) {
            nw.add(item.reweight(item.getWeight() / sum));
        }
        return nw;
    }

    public double getSumWeights() {
        double s = 0.0;
        for (WeightedItem<T> item : this.items) {
            s += item.getWeight();
        }
        return s;
    }

    public WeightedItems<T> clone() {
        try {
            WeightedItems c = (WeightedItems)super.clone();
            c.items = (ArrayList)this.items.clone();
            return c;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public static <T> boolean equals(WeightedItems<T> l, WeightedItems<T> r) {
        return Comparator.equals(l.items, r.items);
    }
}

