/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.xml.legacy.core.XmlTimeDomain;
import jdplus.toolkit.base.xml.legacy.core.XmlTsPeriod;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TsDomainType", propOrder={"frequency", "firstYear", "firstPeriod", "length"})
public class XmlTsDomain
extends XmlTimeDomain {
    @XmlElement(name="Frequency")
    @XmlSchemaType(name="unsignedShort")
    protected int frequency;
    @XmlElement(name="FirstYear", required=true)
    @XmlSchemaType(name="gYear")
    protected int firstYear;
    @XmlElement(name="FirstPeriod")
    @XmlSchemaType(name="unsignedShort")
    protected Integer firstPeriod;
    @XmlElement(name="Length")
    @XmlSchemaType(name="unsignedInt")
    protected int length;
    private static final Adapter ADAPTER = new Adapter();

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int value) {
        this.frequency = value;
    }

    public int getFirstYear() {
        return this.firstYear;
    }

    public void setFirstYear(int value) {
        this.firstYear = value;
    }

    public Integer getFirstPeriod() {
        return this.firstPeriod;
    }

    public void setFirstPeriod(Integer value) {
        this.firstPeriod = value;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public static Adapter getAdapter() {
        return ADAPTER;
    }

    public static class Adapter
    extends XmlAdapter<XmlTsDomain, TsDomain> {
        public TsDomain unmarshal(XmlTsDomain x) {
            TsPeriod p = XmlTsPeriod.of(x.frequency, x.firstYear, x.firstPeriod);
            return TsDomain.of((TsPeriod)p, (int)x.length);
        }

        public XmlTsDomain marshal(TsDomain v) {
            XmlTsDomain x = new XmlTsDomain();
            TsPeriod start = v.getStartPeriod();
            x.frequency = start.getUnit().getAnnualFrequency();
            x.firstPeriod = x.frequency != 1 ? Integer.valueOf(start.annualPosition() + 1) : null;
            x.firstYear = start.year();
            x.length = v.getLength();
            return x;
        }
    }
}

