/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.regression;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.xml.legacy.regression.TsVariableAdapter;
import jdplus.toolkit.base.xml.legacy.regression.XmlRegressionVariable;
import jdplus.toolkit.base.xml.legacy.regression.XmlSpan;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="InterventionVariableType", propOrder={"sequence", "deltaFilter", "deltaSeasonalFilter"})
public class XmlInterventionVariable
extends XmlRegressionVariable {
    @XmlElement(name="Sequence")
    protected List<XmlSpan> sequence;
    @XmlElement(name="DeltaFilter")
    protected Double deltaFilter;
    @XmlElement(name="DeltaSeasonalFilter")
    protected Double deltaSeasonalFilter;
    private static final Adapter ADAPTER = new Adapter();

    public List<XmlSpan> getSequences() {
        if (this.sequence == null) {
            this.sequence = new ArrayList<XmlSpan>();
        }
        return this.sequence;
    }

    public Double getDeltaFilter() {
        return this.deltaFilter;
    }

    public void setDeltaFilter(Double value) {
        this.deltaFilter = value != null && value == 0.0 ? null : value;
    }

    public Double getDeltaSeasonalFilter() {
        return this.deltaSeasonalFilter;
    }

    public void setDeltaSeasonalFilter(Double value) {
        this.deltaSeasonalFilter = value != null && value == 0.0 ? null : value;
    }

    public static final Adapter getAdapter() {
        return ADAPTER;
    }

    public static class Adapter
    extends TsVariableAdapter {
        public InterventionVariable unmarshal(XmlRegressionVariable var) {
            if (!(var instanceof XmlInterventionVariable)) {
                return null;
            }
            XmlInterventionVariable v = (XmlInterventionVariable)var;
            if (v.sequence == null || v.sequence.isEmpty()) {
                return null;
            }
            InterventionVariable.Builder builder = InterventionVariable.builder();
            if (v.deltaFilter != null) {
                builder.delta(v.deltaFilter.doubleValue());
            }
            if (v.deltaSeasonalFilter != null) {
                builder.deltaSeasonal(v.deltaSeasonalFilter.doubleValue());
            }
            for (XmlSpan seq : v.sequence) {
                builder.sequence(Range.of((Comparable)seq.getFrom().atStartOfDay(), (Comparable)seq.getTo().atStartOfDay()));
            }
            return builder.build();
        }

        public XmlInterventionVariable marshal(ITsVariable v) {
            if (!(v instanceof InterventionVariable)) {
                return null;
            }
            InterventionVariable t = (InterventionVariable)v;
            XmlInterventionVariable xml = new XmlInterventionVariable();
            xml.setDeltaFilter(t.getDelta());
            xml.setDeltaSeasonalFilter(t.getDeltaSeasonal());
            List<XmlSpan> sequences = xml.getSequences();
            List seqs = t.getSequences();
            for (Range seq : seqs) {
                XmlSpan span = new XmlSpan();
                span.setFrom(((LocalDateTime)seq.start()).toLocalDate());
                span.setTo(((LocalDateTime)seq.end()).toLocalDate());
                sequences.add(span);
            }
            return xml;
        }

        @Override
        public void xmlClasses(List<Class> lclass) {
            lclass.add(XmlInterventionVariable.class);
        }
    }
}

