% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Event.R
\name{Event}
\alias{Event}
\title{R6 class to create and represent an event}
\description{
R6 class to create and represent an event

R6 class to create and represent an event
}
\examples{
# This handler prints increases a counter in the state of the 
# Simulation object, and schedule another event every 0.1 time unit.
handler = function(time, sim, agent) {
  x = getState(sim)
  x$counter = x$counter + 1
  setState(sim, x)
  schedule(agent, newEvent(time + 0.1, handler))
}
# create a new simulation with no agents. but the simulation itself is
# an agent. So we can use all the methods of agent
sim = Simulation$new()
# set the state of the simulation, initialize the counter
sim$state = list(counter = 0)
# schedule a new event at time 0
sim$schedule(Event$new(0, handler))
# add a logger for the counter. Note that, because sim is an R6 class
# to use it in the newStateLogger function, we need to access the 
# external pointer using its $get method
sim$addLogger(newStateLogger("counter", sim$get, "counter"))
# run the simulation for 10 time units.
print(sim$run(0:10))
# interestingly, the counts are not exactly in 10 event time unit. 
# Firstly, report always happen before event, so event at time 0 is 
# not counted in the time interval 0 to 1. Secondly, the event time 
# is stored as a numeric value with increments of 0.1, which is 
# subject to rounding errors. So some the the integer tiome events
# may be before the reporting and some may be after.

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{time}}{returns the event time}

\item{\code{get}}{returns the external pointer, which can then be passed to
functions such as schdule and unschedule.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-R6Event-new}{\code{Event$new()}}
\item \href{#method-R6Event-clone}{\code{Event$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Event-new"></a>}}
\if{latex}{\out{\hypertarget{method-R6Event-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$new(time, handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time}}{the time that this event will occur. A length-1
numeric vector.}

\item{\code{handler}}{an R function that handles the event when it occurs.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The R handler function should take exactly 3 arguments
\enumerate{
\item time: the current time in the simulation
\item sim: the simulation object, an external pointer
\item agent: the agent to whom this event is attached to.
}

The return value of the handler function is ignored.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Event-clone"></a>}}
\if{latex}{\out{\hypertarget{method-R6Event-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
