% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AGD-package.R
\docType{data}
\name{References CDC}
\alias{References CDC}
\alias{cdc.hgt}
\alias{cdc.wgt}
\alias{cdc.bmi}
\title{Reference tables from CDC 2000}
\format{A data frame with seven variables: \describe{
\item{list("pop")}{Study Population} \item{list("sub")}{Subpopulation}
\item{list("sex")}{Sex (M,F)} \item{list("x")}{Decimal age (0-5 years)}
\item{list("L")}{Lambda (skewness) curve} \item{list("M")}{Median curve}
\item{list("S")}{Coefficient of Variation curve} }}
\source{
Kuczmarski RJ, Ogden CL, Guo SS, Grummer-Strawn LM, Flegal KM, Mei Z,
Wei R, Curtin LR, Roche AF, Johnson CL.  2000 CDC growth charts for the
United States: methods and development.  \emph{Vital Health Stat}, 2002,
\bold{11}, 246, 1-190.
}
\description{
Reference tables from CDC 2000
}
\details{
The models were fitted by the LMS model. Parameters are stored as type
\code{LMS}. Tabulated values are point ages.

The naming conventions are as follows: \describe{
\item{list("cdc.hgt")}{Combined length/height (cm) for Age, 0-20 years.
Measures <2 years apply to length (lying), while ages >= 2 years apply to
height, or stature (standing).} 
\item{list("cdc.wgt")}{Weight (kg) for Age, 0-20 years.} 
\item{list("cdc.bmi")}{Body Mass Index (kg/m2) for Age, 2-20 years.}}
}
\seealso{
\code{\link{nl4.wgt}}, \code{\link{nl4.hgt}}, \code{\link{nl4.bmi}},
\code{\link{who.wgt}}
}
\keyword{datasets}
