% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apis_functions.R
\name{sim_data_fe}
\alias{sim_data_fe}
\title{Simulate space-time stochastic process with fixed-effect}
\usage{
sim_data_fe(
  dataset,
  N,
  TT,
  spatial = 100,
  Tau = -0.14,
  Rho = 0.67,
  Beta = 1,
  sdDev = 5,
  startingT = 11,
  LONGLAT = TRUE
)
}
\arguments{
\item{dataset}{SpatialObject with the spatial units for which the data will be simulated}

\item{N}{How many spatial units will be used}

\item{TT}{Time dimension of the simulated process}

\item{spatial}{Radius that defines the scope of spatial dependence}

\item{Tau}{Autocorrelation parameter}

\item{Rho}{Spatial dependence parameter}

\item{Beta}{Coefficient associated to the exogenous variable}

\item{sdDev}{Standard Deviation of the (gaussian) error term}

\item{startingT}{The number of time periods after which the simulated data will be recorded}

\item{LONGLAT}{Boolean. If the projection is longlat}
}
\value{
A list with two objects. The first object is the STFDF with the simulated data. The second object is the spatial weight matrix
}
\description{
This function simulates a space-time stochastic process according to the defined spatial structure and input paramters. It simulates data of a dynamic spatial lag model. It includes one exogenous variable and a fixed-effect correlated with the exogenous variable.
}
\examples{
\donttest{
library(spacetime)
library(sp)
library(spdep)
set.seed(123)
sd = sim_data_fe(dataset=regsamp,N=100,TT=8,
                 spatial = 80,Tau = -0.2,Rho = 0.4,
                 Beta = 2,sdDev = 2,startingT = 10,
                 LONGLAT = TRUE)
stplot(sd[[1]][,,'Y'])
dev.new()
plot(sel_regioni)
points(coordinates(sd[[1]]@sp))
plot(mat2listw(sd[[2]]),coordinates(sd[[1]]@sp),add=TRUE,col=2)
}

}
