% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMadd.R
\name{arith}
\alias{arith}
\title{ICAR Arithmetic Generator}
\usage{
arith(numProbs = 5, numOps = 1, magnitude = 1, arithOps = "add",
  allowNeg = FALSE, sameValue = FALSE, order = "mixed")
}
\arguments{
\item{numProbs}{Number of desired problems}

\item{numOps}{sets the number of operations in the stimuli (range of values is 1 to 5)}

\item{magnitude}{sets the range of values for the integers in the stimuli by powers of 10 (range of values is 1 to 5)}

\item{arithOps}{There are two options in this argument, either 'add' or 'subtract', "multiply.}

\item{allowNeg}{Allow the use of negative values. Only for "add" arithmetic operator. Not allowed for "subtract".}

\item{sameValue}{Deciding if you want the values to be the same or different values.}

\item{order}{There are three options to order the values presented, ("mixed", "descending", "ascending"). Does not matter when same Value = TRUE.}
}
\value{
\describe{
\item{Question}{The arithmetic questions that are automatically generated.}
\item{Code}{First digit is the magnitude. Subsequent digits correspond to the positional values in the question. 0 is positive value, 1 is negative value.}
\item{Answers}{The answer to the question generated.}
\item{Response Options}{Eight response options. }
    }
}
\description{
A basic arithmetic item generator for ICAR.
}
\details{
The arithmetic function can currently generate additive and substractive operators. For the additive operators, you have the option of using both negative and positive numerical values. For the substractive operators, you are currently restricted to only using positive numerical values. There are also options for you to select the order of the values. It can be in ascending, descending or mixed order. Currently, there are 4 types of distractors that are generated now. 1a,1b distractor types are developed for addition and subtraction questions, whereas, 2a,2b distractor types are developed for multiplication questions.

Distactor type 1a is used for all arithmetic operators. Distractor type 1a is generated such that the values are very near +1/+2/+3 or -1/-2/-3 from the actual answers. Distractor type 1b is generated such as it takes values from a range of values (i.e. number of values * (max(magnitude-1) + 1)). In this instance, distractor type 1b cannot be used in multiplication items because the range will be too big. Hence, elimination of distractors becomes very easy.

Distractor type 2a is used in multiplication questions where the values are not the same. The distractors are generated such that one of the numbers are randomly assigned a value of 1,2 or 3. The product of the new values are considerd as one distractor. It will repeat until 5 unique distractors are created. If the multiplication question uses the same value, then a slightly different approach is adopted. In this case, the numbers are randomly drawn three times before we calcuate the product of the values. Again, this process is repeated until 5 unique distractors are achieved.
}
\examples{

arith(numProbs=4, numOps = 4, magnitude = 3, arithOps = "subtract",
 allowNeg = FALSE, sameValue=FALSE, order = "mixed")


}
\author{
Aiden Loe and David Condon
}
\seealso{
\code{\link{lisy}}, \code{\link{spatial2d}}, \code{\link{spatial3d}}
}

