% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bm_particle_intensity}
\alias{bm_particle_intensity}
\title{Simulate 2D particle trajectory follows Brownian Motion}
\usage{
bm_particle_intensity(pos0, M, len_t, mu, sigma)
}
\arguments{
\item{pos0}{initial position for \code{M} particles, matrix with dimension M by 2}

\item{M}{number of particles}

\item{len_t}{number of time steps}

\item{mu}{mean velocity of the drift}

\item{sigma}{distance moved per time step}
}
\value{
Position matrix with dimension \code{M}\eqn{\times}{\%\times}\code{len_t}
by 2 for particle trajectory. The first \code{M} rows being the initial position
\code{pos0}.
}
\description{
Simulate 2D particle trajectory follows Brownian Motion (BM) for \code{M}
particles.
}
\examples{
library(AIUQ)
M = 10
len_t = 50
mu = 0
sigma = 0.5
pos0 = matrix(100/8+0.75*100*runif(M*2),nrow=M,ncol=2)

pos = bm_particle_intensity(pos0=pos0,M=M,len_t=len_t,mu=mu,sigma=sigma)
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
