% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms.old}
\alias{microorganisms.old}
\title{Data set with previously accepted taxonomic names}
\format{A \code{\link{data.frame}} with 21,342 observations and 4 variables:
\describe{
  \item{\code{col_id}}{Catalogue of Life ID that was originally given}
  \item{\code{col_id_new}}{New Catalogue of Life ID that responds to an entry in the \code{\link{microorganisms}} data set}
  \item{\code{fullname}}{Old full taxonomic name of the microorganism}
  \item{\code{ref}}{Author(s) and year of concerning scientific publication}
}}
\source{
Catalogue of Life: Annual Checklist (public online taxonomic database), \url{http://www.catalogueoflife.org} (check included annual version with \code{\link{catalogue_of_life_version}()}).
}
\usage{
microorganisms.old
}
\description{
A data set containing old (previously valid or accepted) taxonomic names according to the Catalogue of Life. This data set is used internally by \code{\link{as.mo}}.
}
\section{Catalogue of Life}{

\if{html}{\figure{logo_col.png}{options: height=40px style=margin-bottom:5px} \cr}
This package contains the complete taxonomic tree of almost all microorganisms (~65,000 species) from the authoritative and comprehensive Catalogue of Life (\url{http://www.catalogueoflife.org}). The Catalogue of Life is the most comprehensive and authoritative global index of species currently available.

\link[=catalogue_of_life]{Click here} for more information about the included taxa. The Catalogue of Life releases updates annually; check which version was included in this package with \code{\link{catalogue_of_life_version}()}.
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\seealso{
\code{\link{as.mo}} \code{\link{mo_property}} \code{\link{microorganisms}}
}
\keyword{datasets}
