#' Data used in Chapter 3
#'
#' @description
#' Data used in Chapter 3 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * sampleI (used in examples 3.1, 3.2, 3.3, exercise 3.17)
#' * sampleII (used in examples 3.1, 3.2, 3.3, exercise 3.17)
#' * heartrates1 (used in examples 3.4, 3.11)
#' * heartrates2 (used in examples 3.5, 3.6, 3.7)
#' * withties (used in example 3.8)
#' * tiedifrounded1 (used in example 3.8)
#' * tiedifrounded2 (used in example 3.8)
#' * ages (used in example 3.8, exercise 3.9)
#' * sampleA (used in example 3.12)
#' * sampleB (used in examples 3.12, 3.13)
#' * sampleA2 (used in example 3.12)
#' * sampleA3 (used in example 3.12)
#' * heartrates2a (used in example 3.14)
#' * heartrates2b (used in example 3.14)
#' * sampleIa (used in exercise 3.1)
#' * parkingtime (used in exercise 3.3)
#' * Svals (used in exercise 3.4)
#' * children (used in exercise 3.6)
#' * fishlengths (used in exercises 3.7, 3.11)
#' * sleeptime (used in exercise 3.10)
#' * weightloss (used in exercise 3.12)
#' * plants (used in exercise 3.13)
#' * birthprops (used in exercise 3.14)
#' * assembly (used in exercise 3.15)
#' * weightchange (used in exercise 3.16)
#'
#' @format ## `ch3`
#' A list with 25 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch3"

#' Data used in Chapter 4
#'
#' @description
#' Data used in Chapter 4 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * breaks (used in example 4.2)
#' * ages (used in example 4.4)
#' * McAlpha (used in example 4.5)
#' * precipitation (used in example 4.13)
#' * tosses1 (used in example 4.14)
#' * tosses2 (used in example 4.14)
#' * tosses3 (used in example 4.14)
#' * births (used in example 4.15)
#' * times.as.degrees (used in example 4.16)
#' * dates.as.degrees (used in example 4.17)
#' * McGamma (used in exercise 4.1)
#' * waiting.time (used in exercise 4.2)
#' * visiting.supporters (used in exercise 4.3)
#' * days.waiting (used in exercise 4.8)
#' * rainfall.by.latitude (used in exercise 4.9)
#' * points (used in exercise 4.10)
#' * rainfall.DRC (used in exercise 4.11)
#' * piped.water.DRC (used in exercise 4.12)
#' * accident.bearings (used in exercise 4.13)
#' * board.angles (used in exercise 4.14)
#' * arrow.angles (used in exercise 4.15)
#' * football.results (used in exercise 4.17)
#'
#' @format ## `ch4`
#' A list with 22 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch4"

#' Data used in Chapter 5
#'
#' @description
#' Data used in Chapter 5 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * LVF (used in example 5.1, exercise 6.2)
#' * RVF (used in example 5.1, exercise 6.2)
#' * arithmetic (used in example 5.2)
#' * bp (used in example 5.3)
#' * bp.incorrect (used in example 5.3)
#' * yr0910 (used in example 5.10)
#' * yr1314 (used in example 5.10)
#' * bp.diff (used in exercise 5.1)
#' * LabI (used in exercise 5.2)
#' * LabII (used in exercise 5.2)
#' * parent (used in exercise 5.4)
#' * online (used in exercise 5.5)
#' * lectures (used in exercise 5.5)
#' * additiveA (used in exercise 5.9)
#' * additiveB (used in exercise 5.9)
#' * round2 (used in exercise 5.10)
#' * round3 (used in exercise 5.10)
#' * pollA (used in exercise 5.11)
#' * pollB (used in exercise 5.11)
#' * kHz0.125 (used in exercise 5.12)
#' * kHz0.25 (used in exercise 5.12)
#'
#' @format ## `ch5`
#' A list with 21 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch5"

#' Data used in Chapter 6
#'
#' @description
#' Data used in Chapter 6 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * groupA (used in examples 6.1, 6.2, 6.3, 6.10, 6.17)
#' * groupB (used in examples 6.1, 6.2, 6.3, 6.10, 6.17)
#' * groupA.sch2 (used in example 6.4)
#' * groupB.sch2 (used in example 6.4)
#' * groupA.sch2.grp (used in example 6.5)
#' * groupB.sch2.grp (used in example 6.5)
#' * McGamma (used in example 6.6)
#' * McBeta (used in example 6.6)
#' * males (used in examples 6.7, 6.8)
#' * females (used in examples 6.7, 6.8)
#' * sampleI (used in example 6.9)
#' * sampleII (used in example 6.9)
#' * typeA (used in examples 6.11, 6.12, 6.13, exercises 6.11, 6.12)
#' * typeB (used in examples 6.11, 6.12, 6.13, exercises 6.11, 6.12)
#' * groupI (used in example 6.14)
#' * groupII (used in example 6.14)
#' * groupI.trimmed (used in example 6.14)
#' * groupI.amended (used in example 6.14)
#' * salivaF (used in examples 6.15, 6.16)
#' * salivaM (used in examples 6.15, 6.16)
#' * sex (used in example 6.18)
#' * temp.H (used in exercise 6.1)
#' * temp.L (used in exercise 6.1)
#' * DMF.M (used in exercise 6.3)
#' * DMF.F (used in exercise 6.3)
#' * weight.diabetic (used in exercise 6.4)
#' * weight.normal (used in exercise 6.4)
#' * cooling.time.standard (used in exercise 6.5)
#' * cooling.time.cheap (used in exercise 6.5)
#' * wait.1979 (used in exercise 6.6)
#' * wait.1983 (used in exercise 6.6)
#' * activity.boys (used in exercise 6.7)
#' * activity.girls (used in exercise 6.7)
#' * time.withoutLD (used in exercises 6.13, 6.14)
#' * time.withLD (used in exercises 6.13, 6.14)
#' * doseI (used in exercise 6.15)
#' * doseII (used in exercise 6.15)
#' * doseI.2 (used in exercise 6.15)
#' * travel (used in exercise 6.16)
#' * politics (used in exercise 6.16)
#' * twins (used in exercise 6.17)
#'
#' @format ## `ch6`
#' A list with 41 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch6"

#' Data used in Chapter 7
#'
#' @description
#' Data used in Chapter 7 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * affordability (used in example 7.1, exercise 7.16)
#' * regions (used in example 7.1, exercise 7.16)
#' * age (used in example 7.2)
#' * positions (used in example 7.2)
#' * dementia.age (used in examples 7.3, 7.9)
#' * features (used in examples 7.3, 7.9)
#' * time (used in examples 7.4, 7.5)
#' * surgeon (used in examples 7.4, 7.5)
#' * pulse (used in example 7.6)
#' * student (used in example 7.6)
#' * time.period (used in example 7.6)
#' * nodes (used in example 7.7)
#' * treatment (used in example 7.7)
#' * block (used in example 7.7)
#' * outcome (used in example 7.8)
#' * member (used in example 7.8)
#' * climb (used in example 7.8)
#' * procedure.time (used in example 7.10)
#' * team.member (used in example 7.10)
#' * sentences (used in exercise 7.2)
#' * author (used in exercise 7.2)
#' * head.width (used in exercise 7.4)
#' * species (used in exercise 7.4)
#' * braking.distance (used in exercise 7.5)
#' * speed (used in exercise 7.5)
#' * platelet.count (used in exercise 7.6)
#' * spleen.size (used in exercise 7.6)
#' * liver.weight (used in exercise 7.7)
#' * dose (used in exercise 7.7)
#' * house (used in exercise 7.7)
#' * mark (used in exercise 7.8)
#' * scheme (used in exercise 7.8)
#' * candidate (used in exercise 7.8)
#' * prem.contractions (used in exercise 7.9)
#' * drug (used in exercise 7.9)
#' * patient (used in exercise 7.9)
#' * births (used in exercise 7.11)
#' * week (used in exercise 7.11)
#' * weekday (used in exercise 7.11)
#' * names.recalled (used in exercise 7.12)
#' * group (used in exercise 7.12)
#' * medical.student (used in exercise 7.12)
#' * soc.media.use (used in exercise 7.14)
#' * participant (used in exercise 7.14)
#' * day (used in exercise 7.14)
#' * braking.distance.2 (used in exercise 7.15)
#' * initial.speed (used in exercise 7.15)
#'
#' @format ## `ch7`
#' A list with 47 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch7"

#' Data used in Chapter 8
#'
#' @description
#' Data used in Chapter 8 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * plant.weight (used in example 8.2)
#' * growth.hormone (used in examples 8.6, 8.7)
#' * undersoil.heating (used in examples 8.6, 8.7)
#' * plant.weight.2 (used in example 8.6)
#' * plant.weight.3 (used in examples 8.4, 8.5)
#' * plant.weight.4 (used in example 8.7)
#' * sequence (used in example 8.9)
#' * periodI (used in example 8.9)
#' * periodII (used in example 8.9)
#' * sentences (used in example 8.10)
#' * authors (used in example 8.10)
#' * prey.preference (used in example 8.11)
#' * prey (used in example 8.11)
#' * larva (used in example 8.11)
#' * game.time (used in exercise 8.3)
#' * experience (used in exercise 8.3)
#' * game (used in exercise 8.3)
#' * periodI.mistakes.AB (used in exercise 8.6)
#' * periodII.mistakes.AB (used in exercise 8.6)
#' * periodI.mistakes.BA (used in exercise 8.6)
#' * periodII.mistakes.BA (used in exercise 8.6)
#' * periodI.time.AB (used in exercise 8.7)
#' * periodII.time.AB (used in exercise 8.7)
#' * periodI.time.BA (used in exercise 8.7)
#' * periodII.time.BA (used in exercise 8.7)
#' * seizure.score (used in exercises 8.8, 8.9)
#' * hospital (used in exercises 8.8, 8.9)
#' * silver.content (used in exercise 8.10)
#' * dynasty (used in exercise 8.10)
#'
#' @format ## `ch8`
#' A list with 29 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch8"

#' Data used in Chapter 9
#'
#' @description
#' Data used in Chapter 9 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * symp.survtime (used in examples 9.1, 9.3)
#' * symp.censor (used in examples 9.1, 9.3)
#' * asymp.survtime (used in examples 9.1, 9.3)
#' * asymp.censor (used in examples 9.1, 9.3)
#' * sampleI.survtime (used in following example 9.3, example 9.4)
#' * sampleI.censor (used in example 9.4)
#' * sampleII.survtime (used in example 9.4)
#' * sampleII.survtime.2 (used in following example 9.3)
#' * sampleII.censor (used in example 9.4)
#' * samplesAB.survtime (used in example 9.6)
#' * samplesAB.censor (used in example 9.6)
#' * samplesAB (used in example 9.6)
#' * samplesXYZ.survtime (used in example 9.7)
#' * samplesXYZ.censor (used in example 9.7)
#' * samplesXYZ (used in example 9.7)
#' * boys.toothtime (used in exercise 9.2)
#' * girls.toothtime (used in exercise 9.2)
#' * regimeA.survtime (used in exercises 9.5, 9.6)
#' * regimeA.censor (used in exercises 9.5, 9.6)
#' * regimeB.survtime (used in exercises 9.5, 9.6)
#' * regimeB.censor (used in exercises 9.5, 9.6)
#' * bulbA (used in exercise 9.8)
#' * bulbB (used in exercise 9.8)
#'
#' @format ## `ch9`
#' A list with 23 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch9"

#' Data used in Chapter 10
#'
#' @description
#' Data used in Chapter 10 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * q1 (used in section 10.1.2, examples 10.2, 10.5, 10.9)
#' * q2 (used in section 10.1.2, examples 10.2, 10.5, 10.9)
#' * death.year (used in examples 10.4, 10.8)
#' * age.at.death (used in examples 10.4, 10.8, exercise 10.5)
#' * diving.rank (used in example 10.10)
#' * competitors (used in example 10.10)
#' * judges (used in example 10.10)
#' * dentistA (used in example 10.11)
#' * dentistB (used in example 10.11)
#' * questionnaire (used in example 10.12, exercise 10.13)
#' * demonstration (used in example 10.12, exercise 10.13)
#' * gender (used in exercise 10.13)
#' * items (used in example 10.12)
#' * ERA (used in exercises 10.1, 10.3, 10.6, 10.7)
#' * ESMS (used in exercises 10.1, 10.3, 10.6)
#' * SSS (used in exercise 10.7)
#' * British (used in example 10.8, exercise 10.10)
#' * American (used in example 10.8, exercise 10.10)
#' * Canadian (used in example 10.9, exercise 10.10)
#' * Australian (used in example 10.9, exercise 10.10)
#' * design (used in exercise 10.10)
#' * country (used in exercise 10.10)
#' * marks (used in exercise 10.11)
#' * script (used in exercise 10.11)
#' * examiner (used in exercise 10.11)
#' * observerA (used in exercise 10.12)
#' * observerB (used in exercise 10.12)
#'
#' @format ## `ch10`
#' A list with 27 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch10"

#' Data used in Chapter 11
#'
#' @description
#' Data used in Chapter 11 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * parentlimit (used in examples 11.2, 11.3, 11.4, 11.6)
#' * reportedtime (used in examples 11.2, 11.3, 11.4, 11.6)
#' * age (used in example 11.5)
#' * length (used in example 11.5)
#' * parentlimit.2 (used in example 11.7)
#' * reportedtime.2 (used in example 11.7)
#' * days.stored (used in exercise 11.3)
#' * rotten (used in exercise 11.3)
#' * ERA (used in exercise 11.6)
#' * ESMS (used in exercise 11.6)
#' * depth (used in exercise 11.8)
#' * ammonia (used in exercise 11.8)
#' * food.weight.A (used in exercise 11.9)
#' * weight.gain.A (used in exercise 11.9)
#' * food.weight.B (used in exercise 11.9)
#' * weight.gain.B (used in exercise 11.9)
#' * SW.England (used in exercise 11.10)
#' * N.Scotland (used in exercise 11.10)
#'
#' @format ## `ch11`
#' A list with 18 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch11"

#' Data used in Chapter 12
#'
#' @description
#' Data used in Chapter 12 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * feedback.freq (used in example 12.1)
#' * PPI.person (used in example 12.1)
#' * infection.site (used in examples 12.2, 12.3)
#' * district (used in examples 12.2, 12.3)
#' * drugYZ (used in example 12.4)
#' * side.effect (used in example 12.4)
#' * drugAB (used in example 12.5)
#' * side.effect.level (used in example 12.5)
#' * time.to.failure (used in example 12.6)
#' * cause (used in example 12.6)
#' * dose (used in examples 12.7, 12.8)
#' * dose.side.effect (used in example 12.7, 12.8)
#' * platelet.count (used in examples 12.9)
#' * spleen.size (used in example 12.9)
#' * last.digits (used in example 12.10)
#' * accidents (used in example 12.11)
#' * accidents.reduced (used in example 12.11)
#' * side.effect.new (used in example 12.12)
#' * side.effect.old (used in example 12.12)
#' * bronchitis (used in exercise 12.1)
#' * otitis.media (used in exercise 12.1)
#' * welsh.language (used in exercise 12.2)
#' * opportunities (used in exercise 12.2)
#' * diagnosis (used in exercise 12.3)
#' * position.played (used in exercise 12.3)
#' * PPI.person.2 (used in exercise 12.4)
#' * feedback.satisfaction (used in exercise 12.4)
#' * win.opinion (used in exercise 12.5)
#' * supporter (used in exercise 12.5)
#' * diabetes.status (used in exercise 12.6)
#' * ethnic.group (used in exercise 12.6)
#' * horse.wins (used in exercise 12.7)
#' * F1.wins (used in exercise 12.8)
#' * strokes (used in exercise 12.9)
#' * recurrent.visits (used in exercise 12.10)
#' * holes (used in exercise 12.11)
#' * first.response (used in exercise 12.12)
#' * second.response (used in exercise 12.12)
#'
#' @format ## `ch12`
#' A list with 38 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch12"

#' Data used in Chapter 13
#'
#' @description
#' Data used in Chapter 13 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * physical.activity (used in examples 13.1, 13.2, exercise 13.2)
#' * tv.viewing (used in examples 13.1, 13.2, exercise 13.2)
#' * gender (used in examples 13.1, 13.2, exercise 13.2)
#' * machine (used in example 13.3)
#' * output.status (used in example 13.3)
#' * material.source (used in example 13.3)
#' * drug (used in example 13.4, section 13.2.5)
#' * side.effects (used in example 13.4, section 13.2.5)
#' * age.group (used in example 13.4, section 13.2.5)
#' * dose (used in examples 13.7, 13.8)
#' * dose.side.effect (used in examples 13.7, 13.8)
#' * alcohol (used in example 13.9)
#' * malformation (used in example 13.9)
#' * frequency (used in example 13.10)
#' * person (used in example 13.10)
#' * medicine (used in exercise 13.7, section 13.3.1)
#' * response (used in exercise 13.7, section 13.3.1)
#' * location (used in exercise 13.7, section 13.3.1)
#' * chemo.drug (used in example 13.12)
#' * chemo.side.effect (used in example 13.12)
#' * group (used in section 13.4)
#' * promoted (used in section 13.4)
#' * company (used in section 13.4)
#' * breakfast.eaten (used in exercise 13.3)
#' * VEL (used in exercise 13.3)
#' * boys.girls (used in exercise 13.3)
#' * cholesterol (used in exercise 13.4)
#' * SBP (used in exercise 13.4)
#' * schooling (used in exercise 13.5)
#' * abortion.attitude (used in exercise 13.5)
#' * PPI.ages (used in exercise 13.9)
#' * PPI.people (used in exercise 13.9)
#' * laid.off (used in exercises 13.10, 13.11)
#' * employee.ages (used in exercise 13.10)
#' * employee.ages.2 (used in exercise 13.11)
#'
#' @format ## `ch13`
#' A list with 35 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch13"

#' Data used in Chapter 14
#'
#' @description
#' Data used in Chapter 14 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * example14.2 (used in examples 14.2, 14.5)
#' * X14.4 (used in exercise 14.4)
#' * Y14.4 (used in exercise 14.4)
#'
#' @format ## `ch14`
#' A list with 3 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch14"

#' Data used in Chapter 15
#'
#' @description
#' Data used in Chapter 15 of "Applied Nonparametric Statistical Methods" (5th edition)
#'
#' * diet (used in section 15.3.5)
#' * BMI (used in section 15.3.1)
#' * wgt.VLCD (used in section 15.3.2)
#' * wgt.norm (used in section 15.3.2)
#' * opdiff (used in section 15.3.5)
#' * optime.VLCD (used in sections 15.3.3, 15.3.6)
#' * optime.norm (used in sections 15.3.3, 15.3.6)
#' * los.VLCD (used in section 15.3.6)
#' * los.norm (used in section 15.3.6)
#' * optime (used in section 15.3.4)
#' * los (used in section 15.3.4)
#'
#' @format ## `ch15`
#' A list with 11 data vectors
#' @source "Applied Nonparametric Statistical Methods" (5th edition)
"ch15"

