% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.R
\name{binom}
\alias{binom}
\title{Perform Binomial test}
\usage{
binom(
  r,
  n,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.cases = 1e+07,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = TRUE
)
}
\arguments{
\item{r}{Number of successes}

\item{n}{Number of trials}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10000000})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{binom()} performs the Binomial test and calculates the Binomial confidence interval and is used in chapters 4, 5 and 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 4.6 from "Applied Nonparametric Statistical Methods" (5th edition)
binom(3, 20)

# Exercise 5.8 from "Applied Nonparametric Statistical Methods" (5th edition)
binom(24, 40, 0.5)

}
