% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_list.R
\name{apa_add_subplot_dat}
\alias{apa_add_subplot_dat}
\title{Add subplots to datasets}
\usage{
apa_add_subplot_dat(
  apa_list,
  subplot_dat,
  subplot_id_column,
  radius = NULL,
  apa_polygon = attr(apa_list, "apa_config")$apa_polygon
)
}
\arguments{
\item{apa_list}{A \code{apa_list}-object that was created with the
[apa_list]-function.}

\item{subplot_dat}{A named list with datasets (\code{sf}-\code{data.frame}s)
about the subplots . Each \code{data.frame} in \code{subplot_dat} has to
have a unique name, a column with the \code{plot_id}, an own id-column
(specified via the \code{subplot_id_column} argument) and a geometry
column. The geometry column either has to contain \code{POLYGON}-data or
\code{POINT}-data (in which case APA-properties in circular neighborhoods
around the points will be calculated.)}

\item{subplot_id_column}{A named vector specifying the id-columns of the
subplot datasets.}

\item{radius}{If a geometry column in \code{subplot_dat} contains
\code{POINT}-data, \code{radius} specifies the radius of the neighborhood
analysis.}

\item{apa_polygon}{Should polygons of the the APA-patches added to the
dataset?}
}
\description{
If there are subplots within the plots for which APA-characteristics should be
calculated, they may be added to the \code{apa_list}.
}
