% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_diversity_counts.R
\name{state_diversity_counts}
\alias{state_diversity_counts}
\title{State- and territory-level diversity}
\usage{
state_diversity_counts(state, resources = load_taxonomic_resources())
}
\arguments{
\item{state}{A character string indicating the Australian state or
territory to calculate the diversity for. Possible values are "NSW", "NT",
"Qld", "WA", "ChI", "SA", "Vic", "Tas", "ACT", "NI", "LHI", "MI", "HI",
"MDI", "CoI", "CSI", and "AR".}

\item{resources}{the taxonomic resources required to make the summary
statistics.  loading this can be slow, so call load_taxonomic_resources
separately to greatly speed this function up and pass the resources in.}
}
\value{
A tibble of diversity counts for the specified state or territory,
including native, introduced, and more complicated species origins.
The tibble has three columns: "origin" indicating the origin of the
species, "state" indicating the Australian state or territory, and
"num_species" indicating the number of species for that origin and state.
}
\description{
For Australian states and territories, use geographic distribution data from
the APC to calculate state-level diversity for native, introduced,
and more complicated species origins
}
\examples{
 \donttest{state_diversity_counts(state = "NSW")}
}
\seealso{
\code{\link{load_taxonomic_resources}}

Other diversity methods: 
\code{\link{create_species_state_origin_matrix}()},
\code{\link{native_anywhere_in_australia}()}
}
\concept{diversity methods}
