% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variable.R
\name{plot_variable}
\alias{plot_variable}
\title{Distribution plot of one variable against one APC dimension}
\usage{
plot_variable(
  dat,
  y_var,
  apc_dimension = "period",
  log_scale = FALSE,
  plot_type = "boxplot",
  geomBar_position = "fill",
  legend_title = NULL,
  ylab = NULL,
  ylim = NULL
)
}
\arguments{
\item{dat}{Dataset containing columns \code{age} and \code{period}.}

\item{y_var}{Character name of the variable to plot.}

\item{apc_dimension}{One of \code{c("age","period","cohort")}. Defaults to
\code{"period"}.}

\item{log_scale}{Indicator if the visualized variable should be log10
transformed. Only used if the variable is numeric. Defaults to FALSE.}

\item{plot_type}{One of \code{c("boxplot","line","line-points")}, specifying
if boxplots or a line plot of median values should be drawn for metric
variables. \code{"line-points"} adds points to the line plot where
observations are available.}

\item{geomBar_position}{Value passed to \code{\link[ggplot2]{geom_bar}} as
\code{position} argument. Only used if the visualized variable is categorical.
Defaults to \code{"fill"}.}

\item{legend_title}{Optional character title for the legend which is drawn
for categorical variables.}

\item{ylab, ylim}{Optional arguments for styling the ggplot.}
}
\value{
ggplot object
}
\description{
Plot the distribution of one variable in the data against age, period or
cohort. Creates a bar plot for categorical variables (see argument
\code{geomBar_position}) and boxplots or a line plot of median values for
metric variables (see \code{plot_type}).
}
\examples{
library(APCtools)
data(travel)

# plot a metric variable
plot_variable(dat = travel, y_var = "mainTrip_distance",
              apc_dimension = "period", log_scale = TRUE)
plot_variable(dat = travel, y_var = "mainTrip_distance",
              apc_dimension = "period", log_scale = TRUE, plot_type = "line")

# plot a categorical variable
plot_variable(dat = travel, y_var = "household_size", apc_dimension = "period")
plot_variable(dat = travel, y_var = "household_size", apc_dimension = "period",
              geomBar_position = "stack")

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
