% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunAPOTC.R
\name{RunAPOTC}
\alias{RunAPOTC}
\title{Run the APackOfTheClones method on a combined Seurat object for
downstream visualization of clonal expansion}
\usage{
RunAPOTC(
  seurat_obj,
  reduction_base = "umap",
  clonecall = "strict",
  ...,
  extra_filter = NULL,
  run_id = NULL,
  clone_scale_factor = "auto",
  rad_scale_factor = 0.95,
  order_clones = TRUE,
  try_place = FALSE,
  repulse = TRUE,
  repulsion_threshold = 1,
  repulsion_strength = 1,
  max_repulsion_iter = 20L,
  override = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{seurat_obj}{Seurat object with one or more dimension reductions and
already have been integrated with a TCR/BCR library with
\code{scRepertoire::combineExpression}.}

\item{reduction_base}{character. The seurat reduction to base the clonal
expansion plotting on. Defaults to \code{'umap'} but can be any reduction present
within the reductions slot of the input seurat object, including custom ones.
If `'pca'``, the cluster coordinates will be based on PC1 and PC2.
However, generally APackOfTheClones is used for displaying UMAP and
occasionally t-SNE versions to intuitively highlight clonal expansion.}

\item{clonecall}{character. The column name in the seurat object metadata to
use. See \code{scRepertoire} documentation for more information about this
parameter that is central to both packages.}

\item{...}{additional "subsetting" keyword arguments indicating the rows
corresponding to elements in the seurat object metadata that should be
filtered by. E.g., \code{seurat_clusters = c(1, 9, 10)} will filter the cells to
those in the \code{seurat_clusters} column with any of the values 1, 9, and 10.
Unfortunately, column names in the seurat object metadata cannot
conflict with the keyword arguments. \emph{\strong{MAJOR NOTE}} if any subsetting
keyword arguments are a \emph{prefix} of any preceding argument names (e.g. a
column named \code{reduction} is a prefix of the \code{reduction_base} argument)
R will interpret it as the same argument unless \emph{both} arguments
are named. Additionally, this means any subsequent arguments \emph{must} be named.}

\item{extra_filter}{character. An additional string that should be formatted
\emph{exactly} like a statement one would pass into \link[dplyr:filter]{dplyr::filter} that does
\emph{additional} filtering to cells in the seurat object - on top of the other
keyword arguments - based on the metadata. This means that it will be
logically AND'ed with any keyword argument filters. This is a more flexible
alternative / addition to the filtering keyword arguments. For example, if
one wanted to filter by the length of the amino acid sequence of TCRs, one
could pass in something like \code{extra_filter = "nchar(CTaa) - 1 > 10"}. When
involving characters, ensure to enclose with single quotes.}

\item{run_id}{character. This will be the ID associated with the data of a
run, and will be used by other important functions like \link{APOTCPlot} and
\link{AdjustAPOTC}. Defaults to \code{NULL}, in which case the ID will be generated
in the following format:

\verb{reduction_base;clonecall;keyword_arguments;extra_filter}

where if keyword arguments and extra_filter are underscore characters if
there was no input for the \code{...} and \code{extra_filter} parameters.}

\item{clone_scale_factor}{Dictates how much to scale each circle(between 0,1)
radius when converting from clonotype counts into circles that represent
individual clonotypes. The argument defaults to the character \code{"auto"}, and
if so, the most visually pleasing factor will be estimated.}

\item{rad_scale_factor}{numeric between 0 and 1. This value decreases the
radius of the smallest clones by this scale factor. And the absolute value
of this decrease will be applied to all packed circles, effectively shrinking
all circles on the spot, and introduce more constant spacing in between.}

\item{order_clones}{logical. Decides if the largest clone circles should be
near cluster centroids. This is highly recommended to be set to TRUE for
increased intuitiveness of the visualization, as resulting plots tend to
give an improved impression of the proportion of expanded clones. If
\verb{FALSE,} will randomly scramble the positions of each circle. For the sake
of being replicable, a random seed is recommended to be set with \link{set.seed}.}

\item{try_place}{If \code{TRUE}, always minimizes distance from a newly placed
circle to the origin in the circle packing algorithm.}

\item{repulse}{If \code{TRUE}, will attempt to push overlapping clusters away from
each other.}

\item{repulsion_threshold}{numeric. The radius that clonal circle clusters
overlap is acceptable when repulsing.}

\item{repulsion_strength}{numeric. The smaller the value the less the
clusters repulse each other per iteration, and vice versa.}

\item{max_repulsion_iter}{integer. The number of repulsion iterations.}

\item{override}{logical. If \code{TRUE}, will override any existing
APackOfTheClones run data with the same \code{run_id}.}

\item{verbose}{logical. Decides if visual cues are displayed to the R console
of the progress.}
}
\value{
A modified version of the input seurat object, which harbors data
necessary for visualizing the clonal expansion of the cells with \link{APOTCPlot}
and has a friendly user interface to modify certain attributes with
\link{AdjustAPOTC}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Computes necessary information for an APackOfTheClones
clonal expansion plot (\link{APOTCPlot}) and stores it in the seurat object.
Gets sizes of unique clones and utilizes a circle-packing algorithm to
pack circles representing individual clones in approximately the same
dimensional reduction (\code{reduction_base}) coordinates.

The parameter \code{extra_filter} along with an unlimited number of additional
keyword arguments can be used to filter the cells by certain conditions
in the metadata, and new results will be stored in addition to other runs
the users may have done.

Each APackOfTheClones run is uniquely identified by the parameters
\code{reduction_base}, \code{clonecall}, \code{extra_filter}, and any additional keywords
passed to filter the metadata. Each distinct run result is stored in the
seurat object and has an associated Id generated from the aforementioned
parameters. To view the id of the latest run, call \link{getLastApotcDataId}.
To view all the ids of previous runs, call \link{getApotcDataIds}. To work further
with a specific run (most importantly, plotting), the user can use this id
in the arguments with is slightly more convenient than passing in the
original RunAPOTC parameters again but both ways work.

If the user wishes to manually customize/fix the expansion plot
generated, the circular packing information can be modified
with the \link{AdjustAPOTC} function.
}
\details{
All APackOfTheClones run data is stored in the Seurat object under
\code{seurat_object@misc$APackOfTheClones}, which is a list of S4 objects of the
type "ApotcData", with each element corresponding to a unique run. The id of
each run is the name of each element in the list. The user
\emph{\strong{really shouldn't}} manually modify anything in the list as it may cause
unexpected behavior with many other functions.

Additionally, it also logs a seurat command associated with the run in the
\code{seurat_object@commands} slot as a "SeuratCommand" object (from Seurat),
where the name of the object in the list is formatted as \code{RunAPOTC.run_id}.
Again, the user should not modify anything in these objects as they are used
by some related functions, mainly \link{AdjustAPOTC}.
}
\examples{
data("combined_pbmc")

# this is the recommended approach to use a custom run_id with default params
combined_pbmc <- RunAPOTC(combined_pbmc, run_id = "default", verbose = FALSE)

# here's a seperate run with some filters to the meta data, where
# `orig.ident` is a custom column in the example data. Notice that it is not
# a `RunAPOTC` parameter but a user keyword argument
combined_pbmc <- RunAPOTC(
    combined_pbmc, run_id = "sample17", orig.ident = c("P17B", "P17L"),
    verbose = FALSE
)

# the exact same thing can be achieved with the `extra_filter` parameter
combined_pbmc <- RunAPOTC(
    combined_pbmc,
    run_id = "sample17",
    extra_filter = "substr(orig.ident, 2, 3) == '17'",
    override = TRUE,
    verbose = FALSE
)

}
\seealso{
\link{APOTCPlot}, \link{AdjustAPOTC}, \link{getApotcDataIds}
}
