% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApotcIndexing.R
\name{getApotcDataIds}
\alias{getApotcDataIds}
\title{Get all run ids of previous RunAPOTC runs on a seurat object}
\usage{
getApotcDataIds(seurat_obj)
}
\arguments{
\item{seurat_obj}{a seurat object that has had RunAPOTC ran on it before in
order of the functions being called.}
}
\value{
a character vector of all run ids of previous RunAPOTC runs, in
the order they were ran in. If there are no runs on the object, it returns
\code{NULL}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A convenience function to get all run ids of previous RunAPOTC run IDs
}
\examples{
pbmc <- RunAPOTC(
    seurat_obj = get(data("combined_pbmc")),
    reduction_base = "umap",
    clonecall = "strict",
    verbose = FALSE
)

getApotcDataIds(pbmc)
#> [1] "umap;CTstrict;_;_"

pbmc <- RunAPOTC(
    seurat_obj = pbmc,
    reduction_base = "umap",
    clonecall = "gene",
    verbose = FALSE
)

getApotcDataIds(pbmc)
#> [1] "umap;CTstrict;_;_" "umap;CTgene;_;_"

}
