% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.analysis.R
\name{spectral.analysis}
\alias{spectral.analysis}
\alias{spectralFrequency}
\title{Spectral Analysis}
\usage{
spectralFrequency(data, pollutant, ...)
}
\arguments{
\item{data}{\code{data.frame} holding data to be analysed,
expected to contain a timestamp data-series called
\code{date} and a measurement time-series to be analysed
identified using the \code{pollutant} argument.}

\item{pollutant}{The name of the time-series,
typically pollutant measurements, to be analysed.}

\item{...}{extra arguments.}
}
\value{
\code{spectralFrequency} uses the \code{show}
argument to control which elements of the functions outputs
are shown but also invisibly returns a \code{list}
of all outputs which can caught using, e.g.:

\code{sfa.mod <- spectralFrequency(data, pollutant)}
}
\description{
Time-series spectral frequency analysis.
}
\details{
\code{spectralFrequency} producing a
time frequency analysis of the requested
\code{pollutant}.
}
\examples{
spectralFrequency(aq.data, "no2")
}
