% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_sites.R
\name{clean_gps}
\alias{clean_gps}
\title{Check and clean GPS data}
\usage{
clean_gps(
  meta = NULL,
  dist_cutoff = 100,
  dist_crs = 3161,
  dist_by = c("site_id", "aru_id"),
  quiet = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{meta}{Data frame. Output of \code{clean_metadata()}.}

\item{dist_cutoff}{Numeric. Maximum distance (m) between GPS points within a
site. Default is 100m but can be set to \code{Inf} to skip.}

\item{dist_crs}{Numeric. Coordinate Reference System to use when calculating
distance (should be one with m).}

\item{dist_by}{Character. Column which identifies sites within which to
compare distance among GPS points. Only valid if \code{dist_cutoff} is not
\code{Inf}.}

\item{quiet}{Logical. Whether to suppress progress messages and other
non-essential updates.}

\item{verbose}{Logical. Show extra loading information. Default \code{FALSE}.}
}
\value{
Data frame of site-level metadata.
}
\description{
Check and clean GPS data from ARU logs. GPS points are checked for obvious
problems (expected range, distance cutoffs and timing) then attached to the
meta data frame. Note that it is often safer and more reliable to create
your own Site Index file including site ids, and GPS coordinates. This file
can be cleaned and prepared with \code{clean_site_index()} instead.
}
\details{
If checking for a maximum distance (\code{dist_cutoff}) among GPS points within a
group (\code{dist_by}), the returned data frame will include a column \code{max_dist},
which represents the largest distance among points within that group.
}
\examples{
\dontshow{if (dir.exists("my_project")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- clean_metadata(project_dir = "my_project")
g <- clean_gps(meta = m)
\dontshow{\}) # examplesIf}
}
