% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermal.R
\name{thermal}
\alias{thermal}
\title{TIR bands to at satellite brightness temperature conversion}
\usage{
thermal(directory = getwd(), crop = "n", ext2crop = "none",
  op_directory = directory, unit = "Deg Kel")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}

\item{op_directory}{Specify the output directory (within double quotes). By default the input satellite image directory will be selected as the output directory.}

\item{unit}{By default the temperature image will be produced in Degree Kelvin. To produce the thermal image in Degree celcius, assign vale "c".
To produce the thermal image in Degree celcius, assign vale "c".}
}
\value{
At Satellite Brightness Temperature images in .tif format in input directory.
}
\description{
Identifies Thermal Infra-Red (TIR) bands and converts them to  at satellite brightness temperature images.
}
\note{
1. FILENAMES OF ANY BAND FILES (*.TIF files) SHOULDN'T CHANGED.

2. Windows users should be careful while assigning directory. Use "/" to seperate folders.

3. Emissivity value used is 1.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
thermal (directory = path, crop = "y", ext2crop = shapefil, unit = "c")
}
