% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/au.test.strat.r
\name{au.test.strat}
\alias{au.test.strat}
\title{Stratified AU testing}
\usage{
au.test.strat(m0list, m1list, r0list, r1list, lowthresh = 1e-12)
}
\arguments{
\item{m0list}{Number of control subjects in each strata}

\item{m1list}{Number of case subjects in each strata}

\item{r0list}{Number of control subjects exposed in each strata}

\item{r1list}{Number of case subjects exposed in each strata}

\item{lowthresh}{A threshold for probabilities below to be considered as zero. Defaults to 1e-12.}
}
\value{
An AU p-value, computed under the likelihood ratio test.
}
\description{
Calculates AU p-values for testing independence in 2x2 case-control tables, while adjusting for categorical covariates. 
Inputs are given as a vector of counts in each strata defined by the covariate(s).
}
\examples{
au.test.strat(c(500, 1250), c(150, 100), c(0, 0), c(10, 5))
}

