% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{CMA5}
\alias{CMA5}
\title{CMA5 constructor.}
\usage{
CMA5(
  data = NULL,
  ID.colname = NA,
  event.date.colname = NA,
  event.duration.colname = NA,
  event.daily.dose.colname = NA,
  medication.class.colname = NA,
  medication.groups = NULL,
  flatten.medication.groups = FALSE,
  medication.groups.colname = ".MED_GROUP_ID",
  carry.only.for.same.medication = FALSE,
  consider.dosage.change = FALSE,
  followup.window.start = 0,
  followup.window.start.unit = c("days", "weeks", "months", "years")[1],
  followup.window.start.per.medication.group = FALSE,
  followup.window.duration = 365 * 2,
  followup.window.duration.unit = c("days", "weeks", "months", "years")[1],
  observation.window.start = 0,
  observation.window.start.unit = c("days", "weeks", "months", "years")[1],
  observation.window.duration = 365 * 2,
  observation.window.duration.unit = c("days", "weeks", "months", "years")[1],
  date.format = "\%m/\%d/\%Y",
  summary = NA,
  event.interval.colname = "event.interval",
  gap.days.colname = "gap.days",
  force.NA.CMA.for.failed.patients = TRUE,
  parallel.backend = c("none", "multicore", "snow", "snow(SOCK)", "snow(MPI)",
    "snow(NWS)")[1],
  parallel.threads = "auto",
  suppress.warnings = FALSE,
  arguments.that.should.not.be.defined = c(carryover.within.obs.window = TRUE,
    carryover.into.obs.window = FALSE),
  ...
)
}
\arguments{
\item{data}{A \emph{\code{data.frame}} containing the medication events used
to compute the CMA. Must contain, at a minimum, the patient unique ID, the
event date and duration, and might also contain the daily dosage and
medication type (the actual column names are defined in the following four
parameters).}

\item{ID.colname}{A \emph{string}, the name of the column in \code{data}
containing the unique patient ID; must be present.}

\item{event.date.colname}{A \emph{string}, the name of the column in
\code{data} containing the start date of the event (in the format given in
the \code{date.format} parameter); must be present.}

\item{event.duration.colname}{A \emph{string}, the name of the column in
\code{data} containing the event duration (in days); must be present.}

\item{event.daily.dose.colname}{A \emph{string}, the name of the column in
\code{data} containing the prescribed daily dose, or \code{NA} if not defined.}

\item{medication.class.colname}{A \emph{string}, the name of the column in
\code{data} containing the medication type, or \code{NA} if not defined.}

\item{medication.groups}{A \emph{vector} of characters defining medication
groups or the name of a column in \code{data} that defines such groups.
The names of the vector are the medication group unique names, while
the content defines them as logical expressions. While the names can be any
string of characters except "\}", it is recommended to stick to the rules for
defining vector names in \code{R}. For example,
\code{c("A"="CATEGORY == 'medA'", "AA"="{A} & PERDAY < 4"} defines two
medication groups: \emph{A} which selects all events of type "medA", and
\emph{B} which selects all events already defined by "A" but with a daily
dose lower than 4. If \code{NULL}, no medication groups are defined. If
medication groups are defined, there is one CMA estimate for each group;
moreover, there is a special group \emph{__ALL_OTHERS__} automatically defined
containing all observations \emph{not} covered by any of the explicitly defined
groups.}

\item{flatten.medication.groups}{\emph{Logical}, if \code{FALSE} (the default)
then the \code{CMA} and \code{event.info} components of the object are lists
with one medication group per element; otherwise, they are \code{data.frame}s
with an extra column containing the medication group (its name is given by
\code{medication.groups.colname}).}

\item{medication.groups.colname}{a \emph{string} (defaults to ".MED_GROUP_ID")
giving the name of the column storing the group name when
\code{flatten.medication.groups} is \code{TRUE}.}

\item{carry.only.for.same.medication}{\emph{Logical}, if \code{TRUE}, the
carry-over applies only across medication of the same type.}

\item{consider.dosage.change}{\emph{Logical}, if \code{TRUE}, the carry-over
is adjusted to also reflect changes in dosage.}

\item{followup.window.start}{If a \emph{\code{Date}} object, it represents
the actual start date of the follow-up window; if a \emph{string} it is the
name of the column in \code{data} containing the start date of the follow-up
window either as the numbers of \code{followup.window.start.unit} units after
the first event (the column must be of type \code{numeric}) or as actual
dates (in which case the column must be of type \code{Date} or a string
that conforms to the format specified in \code{date.format}); if a
\emph{number} it is the number of time units defined in the
\code{followup.window.start.unit} parameter after the begin of the
participant's first event; or \code{NA} if not defined.}

\item{followup.window.start.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.start} refers to (when a number), or
\code{NA} if not defined.}

\item{followup.window.start.per.medication.group}{a \emph{logical}: if there are
medication groups defined and this is \code{TRUE}, then the first event
considered for the follow-up window start is relative to each medication group
separately, otherwise (the default) it is relative to the patient.}

\item{followup.window.duration}{either a \emph{number} representing the
duration of the follow-up window in the time units given in
\code{followup.window.duration.unit}, or a \emph{string} giving the column
containing these numbers. Should represent a period for which relevant
medication events are recorded accurately (e.g. not extend after end of
relevant treatment, loss-to-follow-up or change to a health care provider not
covered by the database).}

\item{followup.window.duration.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.duration} refers to, or \code{NA} if not
defined.}

\item{observation.window.start, observation.window.start.unit, observation.window.duration, observation.window.duration.unit}{the definition of the observation window
(see the follow-up window parameters above for details).}

\item{date.format}{A \emph{string} giving the format of the dates used in the
\code{data} and the other parameters; see the \code{format} parameters of the
\code{\link[base]{as.Date}} function for details (NB, this concerns only the
dates given as strings and not as \code{Date} objects).}

\item{summary}{Metadata as a \emph{string}, briefly describing this CMA.}

\item{event.interval.colname}{A \emph{string}, the name of a newly-created
column storing the number of days between the start of the current event and
the start of the next one; the default value "event.interval" should be
changed only if there is a naming conflict with a pre-existing
"event.interval" column in \code{event.info}.}

\item{gap.days.colname}{A \emph{string}, the name of a newly-created column
storing the number of days when medication was not available (i.e., the
"gap days"); the default value "gap.days" should be changed only if there is
a naming conflict with a pre-existing "gap.days" column in \code{event.info}.}

\item{force.NA.CMA.for.failed.patients}{\emph{Logical} describing how the
patients for which the CMA estimation fails are treated: if \code{TRUE}
they are returned with an \code{NA} CMA estimate, while for
\code{FALSE} they are omitted.}

\item{parallel.backend}{Can be "none" (the default) for single-threaded
execution, "multicore"  (using \code{mclapply} in package \code{parallel})
for multicore processing (NB. not currently implemented on MS Windows and
automatically falls back on "snow" on this platform),  or "snow",
"snow(SOCK)" (equivalent to "snow"), "snow(MPI)" or "snow(NWS)" specifying
various types of SNOW clusters (can be on the local machine or more complex
setups -- please see the documentation of package \code{snow} for details;
the last two require packages \code{Rmpi} and \code{nws}, respectively, not
automatically installed with \code{AdhereR}).}

\item{parallel.threads}{Can be "auto" (for \code{parallel.backend} ==
"multicore", defaults to the number of cores in the system as given by
\code{options("cores")}, while for \code{parallel.backend} == "snow",
defaults to 2), a strictly positive integer specifying the number of parallel
threads, or a more complex specification of the SNOW cluster nodes for
\code{parallel.backend} == "snow" (see the documentation of package
\code{snow} for details).}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{arguments.that.should.not.be.defined}{a \emph{list} of argument names
and pre-defined valuesfor which a warning should be thrown if passed to the
function.}

\item{...}{other possible parameters}
}
\value{
An \code{S3} object of class \code{CMA5} (derived from \code{CMA0})
with the following fields:
\itemize{
 \item \code{data} The actual event data, as given by the \code{data}
 parameter.
 \item \code{ID.colname} the name of the column in \code{data} containing the
 unique patient ID, as given by the \code{ID.colname} parameter.
 \item \code{event.date.colname} the name of the column in \code{data}
 containing the start date of the event (in the format given in the
 \code{date.format} parameter), as given by the \code{event.date.colname}
 parameter.
 \item \code{event.duration.colname} the name of the column in \code{data}
 containing the event duration (in days), as given by the
 \code{event.duration.colname} parameter.
 \item \code{event.daily.dose.colname} the name of the column in \code{data}
 containing the prescribed daily dose, as given by the
 \code{event.daily.dose.colname} parameter.
 \item \code{medication.class.colname} the name of the column in \code{data}
 containing the classes/types/groups of medication, as given by the
 \code{medication.class.colname} parameter.
 \item \code{carry.only.for.same.medication} whether the carry-over applies
 only across medication of the same type, as given by the
 \code{carry.only.for.same.medication} parameter.
 \item \code{consider.dosage.change} whether the carry-over is adjusted to
 reflect changes in dosage, as given by the \code{consider.dosage.change}
 parameter.
 \item \code{followup.window.start} the beginning of the follow-up window, as
 given by the \code{followup.window.start} parameter.
 \item \code{followup.window.start.unit} the time unit of the
 \code{followup.window.start}, as given by the
 \code{followup.window.start.unit} parameter.
 \item \code{followup.window.duration} the duration of the follow-up window,
 as given by the \code{followup.window.duration} parameter.
 \item \code{followup.window.duration.unit} the time unit of the
 \code{followup.window.duration}, as given by the
 \code{followup.window.duration.unit} parameter.
 \item \code{observation.window.start} the beginning of the observation
 window, as given by the \code{observation.window.start} parameter.
 \item \code{observation.window.start.unit} the time unit of the
 \code{observation.window.start}, as given by the
 \code{observation.window.start.unit} parameter.
 \item \code{observation.window.duration} the duration of the observation
 window, as given by the \code{observation.window.duration} parameter.
 \item \code{observation.window.duration.unit} the time unit of the
 \code{observation.window.duration}, as given by the
 \code{observation.window.duration.unit} parameter.
 \item \code{date.format} the format of the dates, as given by the
 \code{date.format} parameter.
 \item \code{summary} the metadata, as given by the \code{summary} parameter.
 \item \code{event.info} the \code{data.frame} containing the event info
 (irrelevant for most users; see \code{\link{compute.event.int.gaps}} for
 details).
 \item \code{CMA} the \code{data.frame} containing the actual \code{CMA}
 estimates for each participant (the \code{ID.colname} column).
}
Please note that if \code{medication.groups} are defined, then the \code{CMA}
and \code{event.info} are named lists, each element containing the CMA and
event.info corresponding to a single medication group (the element's name).
}
\description{
Constructs a CMA (continuous multiple-interval measures of medication
availability/gaps) type 5 object.
}
\details{
\code{CMA5} assumes that, within the observation window, the medication is
used as prescribed and new medication is "banked" until needed (oversupply
from previous events is used first, followed new medication supply).
It computes days of theoretical use by extracting the total number of gap
days from the total time interval between the first and the last event,
accounting for carry over for all medication events within the observation
window.
Thus, it accounts for timing within the observation window, and excludes the
remaining supply at the start of the last event within the observation window.

The formula is
\deqn{(number of days of theoretical use) / (first to last event)}

Observations:
\itemize{
 \item the \code{carry.only.for.same.medication} parameter controls the
 transmission of carry-over across medication changes, producing a "standard"
 \code{CMA5} (default value is FALSE), and an "alternative" \code{CMA5b},
 respectively;
 \item the \code{consider.dosage.change} parameter controls if dosage changes
 are taken into account, i.e. if set as TRUE and a new medication event has a
 different daily dosage recommendation, carry-over is recomputed assuming
 medication use according to the new prescribed dosage (default value is FALSE).
}
}
\examples{
cma5 <- CMA5(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             carry.only.for.same.medication=FALSE,
             consider.dosage.change=FALSE,
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );
}
\seealso{
CMAs 1 to 8 are defined in:

Vollmer, W. M., Xu, M., Feldstein, A., Smith, D., Waterbury, A., & Rand, C.
(2012). Comparison of pharmacy-based measures of medication adherence.
\emph{BMC Health Services Research}, \strong{12}, 155.
\doi{10.1186/1472-6963-12-155}.
}
