% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_analysis.R
\name{weibull}
\alias{weibull}
\title{Analysis: Weibull}
\usage{
weibull(
  trat,
  resp,
  npar = "w3",
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  ic = FALSE,
  fill.ic = "gray70",
  alpha.ic = 0.5,
  error = "SE",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  yname.formula = "y",
  xname.formula = "x",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{npar}{Number of model parameters (\emph{default} is  w3)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{ic}{Add interval of confidence}

\item{fill.ic}{Color interval of confidence}

\item{alpha.ic}{confidence interval transparency level}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{point}{Defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{Shape size}

\item{linesize}{Line size}

\item{pointshape}{Format point (default is 21)}

\item{round}{round equation}

\item{yname.formula}{Name of y in the equation}

\item{xname.formula}{Name of x in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
The w3' and 'w4' logistical models provide Weibull. This model was extracted from the 'drc' package.
}
\details{
The three-parameter Weibull model is given by the expression
\deqn{y = d\exp(-\exp(b(\log(x)-e)))}
Fixing the lower limit at 0 yields the four-parameter model
\deqn{y = c + (d-c) (1 - \exp(-\exp(b(\log(x)-\log(e)))))}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
weibull(trat,resp)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley & Sons (p. 330).

Ritz, C.; Strebig, J.C. and Ritz, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\seealso{
\link{LL}, \link{CD},\link{GP}
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
