% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_select.R
\name{monitor_select}
\alias{monitor_select}
\alias{monitor_reorder}
\title{Subset and reorder time series within an \emph{mts_monitor} object}
\usage{
monitor_select(monitor, id)

monitor_reorder(monitor, id)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{id}{Vector of \code{deviceDeploymentIDs}.}
}
\value{
A reordered (subset) of the incoming \emph{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
This function acts similarly to \code{dplyr::select()} working on
\code{monitor$data}. The returned \emph{mts_monitor} object will contain only
those time series identified by \code{id} in the order specified.

This can be helpful when using faceted plot functions based on \pkg{ggplot}
such as those found in the \pkg{AirMonitorPlots} package.
}
\seealso{
\link{monitor_filterMeta}
}
