% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{initializeGenomeObject}
\alias{initializeGenomeObject}
\title{Genome Initialization}
\usage{
initializeGenomeObject(file, genome = NULL, observed.expression.file = NULL,
  fasta = TRUE, simulated = FALSE, match.expression.by.id = TRUE,
  append = FALSE)
}
\arguments{
\item{file}{A file of coding sequences in fasta or RFPData format}

\item{genome}{A genome object can be passed in to concatenate the input file to it (optional).}

\item{observed.expression.file}{A string containing the location of a file containing
empirical expression rates (optional).}

\item{fasta}{A boolean value which decides whether to initialize with a
fasta file or an RFPData file. (TRUE for fasta, FALSE for RFPData)}

\item{simulated}{boolean to determine if the data should be treated as a simulated data set (Default = FALSE).}

\item{match.expression.by.id}{If TRUE (default), observed expression values will be assigned by matching sequence identifier.
If FALSE, observed expression values will be assigned by order.}

\item{append}{If TRUE (FALSE is default), function will read in additional genome data to append to an existing genome.
If FALSE, genome data is cleared before reading in data (no preexisting data).}
}
\value{
This function returns the initialized Genome object.
}
\description{
\code{initializeGenomeObject} initializes the Rcpp Genome object
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
genes_file <- system.file("extdata", "more_genes.fasta", package = "AnaCoDa")
expression_file <- system.file("extdata", "expression.csv", package = "AnaCoDa")
 
## reading genome
genome <- initializeGenomeObject(file = genome_file)

## reading genome and observed expression data
genome <- initializeGenomeObject(file = genome_file, observed.expression.file = expression_file)
 
## add aditional genes to existing genome
genome <- initializeGenomeObject(file = genome_file)
genome <- initializeGenomeObject(file = genes_file, genome = genome, append = TRUE)   

}
