% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor_regression.R
\name{anchor_regression}
\alias{anchor_regression}
\title{anchor_regression}
\usage{
anchor_regression(x, anchor, gamma, target_variable)
}
\arguments{
\item{x}{x is a dataframe containing the matrix x containing the independent variables}

\item{anchor}{anchor is a dataframe containing the matrix anchor containing the anchor variable}

\item{gamma}{gamma is the regularization parameter for the Anchor Regression}

\item{target_variable}{target_variable is the target variable name contained in the x dataframe}
}
\value{
A list with coefficient values and a list with the respective names \code{overview_print}
}
\description{
Perform an Anchor Regression as described in Rothenhäusler et al.2020
}
\examples{
x <- as.data.frame(matrix(data = rnorm(1000),nrow = 100,ncol = 10))
anchor <- as.data.frame(matrix(data = rnorm(200),nrow = 100,ncol = 2))
colnames(anchor) <- c('X1','X2')
gamma <- 2
target_variable <- 'V2'
anchor_regression(x, anchor, gamma, target_variable)
}
