\name{Fishpond}
\alias{Fishpond}
\docType{data}
\title{
Polynesian fishpond site on the island of Oahu, Hawaii.
}
\description{
MCMC samples from the posterior distribution of dates estimated by BCal software according to a Polynesian fishpond site on the island of Oahu, Hawaii. The site contains two main layers and 5 radiocarbon dates. See the tutorial of BCal for the details of the modeling. 
}
\usage{data("Fishpond")}
\format{
   A data frame with 55965 observations on the following 12 variables contained in the outputs generated by BCal. The MCMC samples are in format cal BP (before 1950).
  \describe{
    \item{\code{Iteration}}{a vector corresponding to iteration number. Here it is a non numeric vector as the last value is "EOF".}
    
    \item{\code{beta.2..Layer.II.}}{a numeric vector containing the output of the MCMC algorithm for the date of the end of Layer II. }
    
    \item{\code{theta.5..Layer.II.}}{a numeric vector containing the output of the MCMC algorithm for the date theta.5.}
    
    \item{\code{theta.4..Layer.II.}}{a numeric vector containing the output of the MCMC algorithm for the date theta.4.}
    
    \item{\code{theta.3..Layer.II.}}{a numeric vector containing the output of the MCMC algorithm for the date theta.3.}
    
    \item{\code{theta.2..Layer.II.}}{a numeric vector containing the output of the MCMC algorithm for the date theta.2.}
    
    \item{\code{alpha.2..Layer.II.}}{a numeric vector containing the output of the MCMC algorithm for the date of the start of Layer II. }
    
    \item{\code{beta.1..Layer.III.}}{a numeric vector containing the output of the MCMC algorithm for the date of the end of Layer III. }
    
    \item{\code{theta.1..Layer.III.}}{a numeric vector containing the output of the MCMC algorithm for the date theta.1.}
    
    \item{\code{alpha.1..Layer.III.}}{a numeric vector containing the output of the MCMC algorithm for the date of the start of Layer III. }
    
     \item{\code{phi.1}}{a numeric vector containing the output of the MCMC algorithm for the floating parameter phi 1. }
    
    \item{\code{X}}{ vector of NA }
    
  }
}

\source{
http://bcal.shef.ac.uk/tutorial/tutorial.html
}
\references{
BCal is an easy to use, on-line Bayesian radiocarbon calibration tool for interpreting radiocarbon data along with expert chronological information. It is hosted by the School of Mathematics and Statistics at the University of Sheffield. See http://bcal.shef.ac.uk/.
}
\examples{
  ##load data
  data(Fishpond)
  # deleting the last row containing "NAs" only
  Fishpond = Fishpond[-55965,]
  # Note that these MCMC samples are in format cal BP (that is in year before 1950). 
  # In order to use the functions from ArhcaheoPhases, the MCMC samples have to be 
  # converted in date format BC/AD, for example, using the following code
  Fishpond2 = Fishpond
    L = length(Fishpond)
    conv <- function(value, T0){
      T0 - value
    }
    for (i in 1:L){
      if( is.numeric(Fishpond[,i]) == TRUE){
        Fishpond2[,i] = sapply(Fishpond[,i], conv, 1950)
      }
    }
}

\keyword{datasets}
\keyword{MCMC output}
\keyword{BCal}

\author{
Anne Philippe <Anne.Philippe@univ-nantes.fr> and

Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
