% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiPhasesTransition.R
\name{MultiPhasesTransition}
\alias{MultiPhasesTransition}
\title{Transition range for a succession of groups
(for groups in temporal order constraint)}
\usage{
MultiPhasesTransition(
  data,
  position_minimum,
  position_maximum = position_minimum + 1,
  level = 0.95
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position_minimum}{Numeric vector containing the column number
corresponding to the minimum of the events included in each group.}

\item{position_maximum}{Numeric vector containing the column number
corresponding to the end of the groups set in the same order as in
code{position_minimum}.}

\item{level}{Probability corresponding to the level of confidence.}
}
\value{
A matrix of values containing the level of confidence and
the endpoints of the transition interval for each pair of successive
groups. The result is given in calendar years (BC/AD).
}
\description{
Finds, if it exists, the shortest interval that satisfies
\eqn{P(TransitionRangeInf < Phase1Max < Phase2Min < TransitionRangeSup | M) = level}
}
\details{
For each \code{i}, \code{MultiPhasesTransition()} computes the transition interval
for the phase defined by its minimum \code{position_minimum[i]} and
its maximum \code{position_maximum[i]}. The default value of
\code{position_maximum} corresponds to CSV files exported from
\href{https://chronomodel.com/}{ChronoModel} software.
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  # List of the name of the groups
  names(Phases)
  # Stipulating position_maximum
  MultiPhasesTransition(Phases, position_minimum = c(4, 2), position_maximum = c(5, 3))
  # In this case, equivalent to
  MultiPhasesTransition(Phases, position_minimum = c(4, 2))

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
