% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda.mcmc.R
\name{coda.mcmc}
\alias{coda.mcmc}
\title{Create an \code{mcmc.list} object for \pkg{coda} users}
\usage{
coda.mcmc(data, numberChains = 1, iterationColumn = NULL)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{numberChains}{Number of parallel chains, default = 1.}

\item{iterationColumn}{Column number corresponding to the iteration values,
default = \code{NULL}.}
}
\value{
An \code{mcmc.list} object.
}
\description{
This wrapper function extracts parallel chains from a data frame to
create an \code{mcmc.list}
object for use with \pkg{coda} diagnostic tools
}
\examples{
  data(Events)
  mcmcList = coda.mcmc(data = Events, numberChains = 3, iterationColumn = 1)
  plot(mcmcList)
  gelman.diag(mcmcList)
  # The multivariate criterion can not be evaluated when a phase
  # contains only one date. This induces colinearity problems.
  gelman.diag(mcmcList, multivariate = FALSE)

}
\seealso{
\code{\link[coda]{mcmc}}

\code{\link[coda]{mcmc.list}}
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
