#' ArctosR: An Interface to the Arctos Database
#'
#' @description
#' The `ArctosR` package provides a set of functions to help users
#' perform requests to the Arctos API to download data. It provides a set of
#' builder classes for performing complex requests, as well as a set of simple
#' functions for automating many common requests and workflows.
#'
#' @section About Arctos:
#' Arctos is community and an online collection management information system.
#' Arctos is a consortium of museums and organizations that collaborate to serve
#' data on over 5 million records from natural and cultural history collections.
#' Arctos integrates access to information from diverse disciplines:
#' anthropology, botany, entomology, ethnology, herpetology, geology,
#' ichthyology, mammalogy, mineralogy, ornithology, paleontology,
#' parasitology as well as archival and cultural collections.
#' The web interface to the Arctos database can be found at
#' https://arctos.database.museum/. For more information about Arctos,
#' see https://arctosdb.org/about/, and
#' Cicero et al. (2024) <doi:10.1371/journal.pone.0296478>.
#'
#' @section Functions in ArctosR:
#' \code{\link{get_query_parameters}}, \code{\link{get_result_parameters}},
#' \code{\link{get_record_count}}, \code{\link{get_records}},
#' \code{\link{response_data}}, \code{\link{save_response_rds}},
#' \code{\link{read_response_rds}}, \code{\link{save_response_csv}},
#' \code{\link{expand_column}}
#'
"_PACKAGE"
