% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{maxScoreSplit}
\alias{maxScoreSplit}
\title{Size-restricted bivariate score maximizing splitting}
\usage{
maxScoreSplit(bin, scorer, minExp = 5, squarify = FALSE)
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{scorer}{function which accepts a numeric vector of potential
split coordinates and the bounds of `bin` and returns a numeric
vector of scores for each}

\item{minExp}{value giving the smallest expected count allowed for
bin splits}

\item{squarify}{logical value, should we force splitting on
the longer side regardless of scores?}
}
\value{
A list of two bins resulting from the split of `bin`
along the corresponding margin at the maximum location
}
\description{
Splits a bin based on the location maximizing a score
function with restrictions on minimum bin size.
}
\details{
This function serves as a wrapper which manages the
logic of splitting bins using a score function while maintaining
a minimum size and allowing forced splits along the wider edge.
}
\examples{
bin <- makeBin(x = 1:10, y = sample(1:10))
maxScoreSplit(bin, chiScores)
maxScoreSplit(bin, miScores) # pretty similar for both
maxScoreSplit(bin, randScores)
maxScoreSplit(bin, randScores) # different every time
}
\author{
Chris Salahub
}
