% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_init.R
\name{build_authorization_uri}
\alias{build_authorization_uri}
\alias{get_device_creds}
\title{Standalone OAuth authorization functions}
\usage{
build_authorization_uri(
  resource,
  tenant,
  app,
  username = NULL,
  ...,
  aad_host = "https://login.microsoftonline.com/",
  version = 1
)

get_device_creds(
  resource,
  tenant,
  app,
  aad_host = "https://login.microsoftonline.com/",
  version = 1
)
}
\arguments{
\item{resource, tenant, app, aad_host, version}{See the corresponding arguments for \link{get_azure_token}.}

\item{username}{For \code{build_authorization_uri}, an optional login hint to be sent to the authorization endpoint.}

\item{...}{Named arguments that will be added to the authorization URI as query parameters.}
}
\value{
For \code{build_authorization_uri}, the authorization URI as a string. This can be set as a redirect from within a Shiny app's UI component.

For \code{get_device_creds}, a list containing the following components:
\itemize{
\item \code{user_code}: A short string to be shown to the user
\item \code{device_code}: A long string to verify the session with the AAD server
\item \code{verification_uri}: The URI the user should browse to in order to login
\item \code{expires_in}: The duration in seconds for which the user and device codes are valid
\item \code{interval}: The interval between polling requests to the AAD token endpoint
\item \code{message}: A string with login instructions for the user
}
}
\description{
Standalone OAuth authorization functions
}
\details{
These functions are mainly for use in embedded scenarios, such as within a Shiny web app. In this case, the interactive authentication flows (authorization code and device code) need to be split up so that the authorization step is handled separately from the token acquisition step. You should not need to use these functions inside a regular R session, or when executing an R batch script.
}
\examples{
build_authorization_uri("https://myresource", "mytenant", "app_id",
                        redirect_uri="http://localhost:8100")

\dontrun{

## obtaining an authorization code separately to acquiring the token
# first, get the authorization URI
auth_uri <- build_authorization_uri("https://management.azure.com/", "mytenant", "app_id")
# browsing to the URI will log you in and redirect to another URI containing the auth code
browseURL(auth_uri)
# use the code to acquire the token
get_azure_token("https://management.azure.com/", "mytenant", "app_id",
    auth_code="code-from-redirect")


## obtaining device credentials separately to acquiring the token
# first, contact the authorization endpoint to get the user and device codes
creds <- get_device_creds("https://management.azure.com/", "mytenant", "app_id")
# print the login instructions
creds$message
# use the creds to acquire the token
get_azure_token("https://management.azure.com/", "mytenant", "app_id",
    auth_type="device_code", device_creds=creds)

}
}
